package com.sfa.job.service.qince.impl;

import com.alibaba.fastjson2.JSONObject;
import com.sfa.common.core.utils.StringUtils;
import com.sfa.common.core.utils.sdk.FeiShuUtil;
import com.sfa.common.core.utils.sdk.FeiShuUtils;
import com.sfa.job.domain.feishu.dao.IQinceMarketEmployeeDao;
import com.sfa.job.domain.qince.dao.IQinceEmployeeDao;
import com.sfa.job.domain.system.dao.ISysUserDao;
import com.sfa.job.pojo.feishu.response.QinceMarketEmployeeDto;
import com.sfa.job.pojo.qince.response.QinceEmployeeDto;
import com.sfa.job.service.qince.IQinceEmpAndDeptService;
import com.sfa.job.util.QinCeUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author : liqiulin
 * @date : 2025-12-29 17
 * @describe :
 */
@Slf4j
@Service
public class QinceEmpAndDeptServiceImpl implements IQinceEmpAndDeptService {
    @Autowired
    private QinCeUtils qinCeUtils;
    @Autowired
    private ISysUserDao sysUserDao;
    @Autowired
    private IQinceEmployeeDao qinceEmployeeDao;
    @Autowired
    private IQinceMarketEmployeeDao qinceMarketEmployeeDao;
    @Override
    public void syncQinceEmpLeaderInfo() {
        // 查询飞书的上下级关系（仅区域销售部）
        Map<String, String> empCodeAndLeader = sysUserDao.selectListEmpAndLeader();
        List<QinceEmployeeDto> qinceEmployeeDtos = qinceEmployeeDao.selectListByEmpcodes(empCodeAndLeader.keySet());
        log.info("飞书-区域销售部共【{}】人", qinceEmployeeDtos.size());

        Set<String> leaderCodes = new HashSet<>(empCodeAndLeader.values());
        List<QinceEmployeeDto> leaderDtos = qinceEmployeeDao.selectListByEmpcodes(leaderCodes);
        Map<String, QinceEmployeeDto> leaderEmpInfoMap = leaderDtos.stream().collect(Collectors.toMap(m -> m.getEmpCode(), m -> m));
        log.info("飞书关联勤策-区域销售部共【{}】人", qinceEmployeeDtos.size());

        for (QinceEmployeeDto empDto : qinceEmployeeDtos) {
            String leaderCode = empCodeAndLeader.get(empDto.getEmpCode());
            QinceEmployeeDto leaderEmpInfo = leaderEmpInfoMap.get(leaderCode);
            // 如果上级为空或上级未发生变化，则不处理
            if (StringUtils.isBlank(leaderCode) || Objects.isNull(leaderEmpInfo) || leaderCode.equals(empDto.getParentCode())) {
                continue;
            }
            updateQinceUserLeader("区域销售部",empDto,leaderEmpInfo);
        }
    }

    /**
     * 更新经销商业代人员上级
     */
    @Override
    public void syncQinceDealerUserLeaderInfo() {
        // 查询经销商人客关系
        List<QinceMarketEmployeeDto> marketDtos = qinceMarketEmployeeDao.selectByTodayUpdate();
        // 查询客户经理的勤策个人信息
        if (CollectionUtils.isEmpty(marketDtos)){
            log.info("push qc 经销商业代上级: 今日无新增/修改经销商");
            return;
        }
        Set<String> marketEmpCodes = marketDtos.stream().map(m -> m.getFEmpNo()).collect(Collectors.toSet());
        List<QinceEmployeeDto> leaderDtos = qinceEmployeeDao.selectListByEmpcodes(marketEmpCodes);
        Map<String, QinceEmployeeDto> leaderEmpInfoMap = leaderDtos.stream().collect(Collectors.toMap(m -> m.getEmpCode(), m -> m));

        if (CollectionUtils.isEmpty(leaderDtos)){
            String logText = "【ERROR】勤员人员信息中，无经销商客户经理信息，经销商包含:" + JSONObject.toJSONString(marketEmpCodes);
            log.info(logText);
            FeiShuUtils.pustRoot(FeiShuUtil.qinceWebhook, logText);
            return;
        }
        for (QinceMarketEmployeeDto marketDto : marketDtos) {
            updateQinceDealerUserLeader(marketDto,leaderEmpInfoMap);
        }

    }

    /**
     * 更新业代上级
     */
    private void updateQinceDealerUserLeader(QinceMarketEmployeeDto marketDto,Map<String, QinceEmployeeDto> leaderEmpInfoMap){
        // 查询勤策-经销商部门下的人员
        String dealerCode = marketDto.getDealerCode();
        List<QinceEmployeeDto> dealerEmpDtos = qinceEmployeeDao.selectListByOrgCode(dealerCode);
        log.info("勤策经销商部门【{}:{}】下共【{}】位业代人员", dealerCode,marketDto.getDealerName(), dealerEmpDtos.size());
        String fEmpNo = marketDto.getFEmpNo();
        if (Objects.isNull(fEmpNo)){
            return;
        }

        QinceEmployeeDto leaderEmpInfo = leaderEmpInfoMap.get(fEmpNo);
        // 对比当前人员上级-经销商客户经理：不同则修改；相同则跳过
        for (QinceEmployeeDto dealerEmpDto : dealerEmpDtos) {
            if (Objects.nonNull(dealerEmpDto.getParentCode()) && fEmpNo.equals(dealerEmpDto.getParentCode())){
                continue;
            }
            updateQinceUserLeader(marketDto.getDealerName(),dealerEmpDto,leaderEmpInfo);
        }
    }

    /**
     * @param empDto 员工对象
     * @param leaderEmpInfo 员工上级对象
     */
    private void updateQinceUserLeader(String qcDeptName,QinceEmployeeDto empDto,QinceEmployeeDto leaderEmpInfo){
        String logtext;
        try {
            Map<String, Object> params = qinCeUtils.putUserLeaderParams(empDto.getQcId(), leaderEmpInfo.getQcId());
            String url = qinCeUtils.builderUrl(QinCeUtils.MODIFY_USER, params);
            qinCeUtils.postQC(url, params);
            logtext = "【OK】更新勤策「"+qcDeptName+"」部门的【" + empDto.getEmpCode() + ":" + empDto.getEmpName() + "】上级Leader为【" + leaderEmpInfo.getEmpCode() + ":" + leaderEmpInfo.getEmpName() + "】成功";
            log.info(logtext);
        } catch (Exception e) {
            logtext = "【ERROR】更新勤策「"+qcDeptName+"」部门的【" + empDto.getEmpCode() + ":" + empDto.getEmpName() + "】上级Leader信息失败：" + e.getMessage();
            log.error(logtext);
        }
        FeiShuUtils.pustRoot(FeiShuUtil.qinceWebhook, logtext);
    }

}
