package com.sfa.job.domain.zzcenter.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.job.domain.zzcenter.dao.IZzProductQualityDao;
import com.sfa.job.domain.zzcenter.entity.ZzProductQuality;
import com.sfa.job.domain.zzcenter.mapper.ZzProductQualityMapper;
import com.sfa.job.pojo.zzcenter.ZzProductQualityDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2025-10-30 15
 * @describe :
 */
@Service
@DS("bi")
public class ZzProductQualityDaoImpl implements IZzProductQualityDao {
    @Autowired
    private ZzProductQualityMapper zzProductQualityMapper;

    @Override
    public List<ZzProductQualityDto> selectListBySyncStatus(Integer syncStatus) {
        LambdaQueryWrapper<ZzProductQuality> qw = new LambdaQueryWrapper<>();
        qw.eq(ZzProductQuality::getSyncStatus, syncStatus);
        List<ZzProductQuality> zzProductQualityList = zzProductQualityMapper.selectList(qw);
        return BeanUtils.transitionDtos(zzProductQualityList, ZzProductQualityDto.class);
    }

    @Override
    public Integer updateSyncStatus(ZzProductQualityDto zzProductQualityDto) {
        ZzProductQuality zzProductQuality = new ZzProductQuality();
        BeanUtils.copyProperties(zzProductQualityDto, zzProductQuality);
        return zzProductQualityMapper.updateById(zzProductQuality);
    }
}
