package com.sfa.job.util;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Map;
import java.util.UUID;

/**
 * @author : liqiulin
 * @date : 2025-04-24 16
 * @describe :
 */
@Slf4j
@Component
public class QinCeUtils {

    /**
     * =================== 勤策API - config ===================
     */
    @Value("${qince.open_api}")
    private String OPEN_API;
    @Value("${qince.open_id}")
    private String OPEN_ID;
    @Value("${qince.app_key}")
    private String APP_KEY;


    /**
     * =================== 勤策API - path ===================
     */
    // 修改经销商
    public static final String MODIFY_DEALER = "/api/dealer/v1/modifyDealer/";

    public String builderUrl(String sidepath, Map<String, Object> params) {
        String msgId = UUID.randomUUID().toString();
        Long currentTimeMillis = System.currentTimeMillis();
        String digest = getDigest(params, currentTimeMillis);
        StringBuilder builder = new StringBuilder().append(OPEN_API).append(sidepath).append(OPEN_ID).append("/").append(currentTimeMillis).append("/").append(digest).append("/").append(msgId);
        return builder.toString();
    }

    public Map<String, Object> modifyDealerParams(){
     return null;
    }



    public JSONObject postQC(String url, Object params) {
        String requestBody = HttpUtil.createPost(url).contentType("application/json;charset=utf-8").header("","").body(JSONObject.toJSONString(params)).execute().body();
        JSONObject resultJson = JSONObject.parseObject(requestBody);
        String returnCode = resultJson.getString("return_code");
        if (!"0".equals(returnCode)) {
            throw new RuntimeException("OkHttp.post请求error，详情：" + requestBody);
        }
        return resultJson;
    }

    private String getDigest(Map<String, Object> params, Long currentTimeMillis) {
        String json = "";
        if (!CollectionUtils.isEmpty(params)) {
            json = JSONObject.toJSONString(params);
        }
        String digest = DigestUtils.md5Hex(json + "|" + APP_KEY + "|" + currentTimeMillis);
        return digest;
    }
}
