package com.sfa.job.service.qince.impl;

import com.alibaba.fastjson.JSONObject;
import com.sfa.job.domain.qince.dao.IQinceDealerDao;
import com.sfa.job.pojo.qince.response.QinceDealerDto;
import com.sfa.job.service.qince.IQinceDealerQueryService;
import com.sfa.job.util.QinCeUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2025-04-24 16
 * @describe :
 */
@Slf4j
@Service
public class QinceDealerQueryServiceImpl implements IQinceDealerQueryService {

    @Autowired
    private IQinceDealerDao qinceDealerDao;
    @Autowired
    private QinCeUtils qinCeUtils;

    @Override
    public void updateQinceDealerInfo() {
        /**
         * 查询需要更新的经销商
         */
        List<QinceDealerDto> pushQinceDealers = qinceDealerDao.getPushQinceDealers();

        /**
         * 反写勤策中的自定义字段：大区、战区
         */
        for (QinceDealerDto dealerDTO : pushQinceDealers) {

            Map<String, Object> ext1 = new HashMap<>();
            ext1.put("dealer_ext_key","大区");
            ext1.put("dealer_ext_value",dealerDTO.getDqOrgName());

            Map<String, Object> ext2 = new HashMap<>();
            ext2.put("dealer_ext_key","战区");
            ext2.put("dealer_ext_value",dealerDTO.getZqOrgName());

            Map<String, Object> params = new HashMap<>();
            params.put("dealer_id",dealerDTO.getDealerId());
            params.put("exts", Arrays.asList(ext1, ext2));


            String url = qinCeUtils.builderUrl(QinCeUtils.MODIFY_DEALER, params);
            qinCeUtils.postQC(url, params);
        }

        log.info("更新勤策经销商战区、大区信息完成，更新量：{}",pushQinceDealers.size());
    }
}
