package com.sfa.job.pojo.response;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * 财务同步旺店通接口-返回数据Dto
 */
@Data
public class SyncOrderDetailDto {
    /**
     * 订单数量
     */
    private Integer orderCount;
    private Integer orderDetailCount;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;
    private Integer syncType;
    private String batchNo;
    private Integer pageNo;
    private Integer totalCount;
    /**
     * 错误信息
     */
    private String message;
    private Integer code = 200;

}
