package com.sfa.job.domain.order.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 退换货订单数据
 * @author lvbencai
 * @date 2025-02-28 12:26:29
 */
@Data
@TableName(value = "wdt_refund_amount_detail")
public class WdtRefundAmountDetail {
    private Integer recId; // 金额明细记录id
    private Integer refundId; // 退换单id
    private Integer refundType; // 退换类型 1:货款 2:邮费 99:返现
    private Integer isReturn; // 金额流向 0:商家->买家 1:买家->商家
    private BigDecimal refundAmount; // 退款金额
    private BigDecimal receiveAmount; // 收款金额
    private Boolean isGuarantee; // 是否担保支付
    private Integer accountId; // 支付账户
    private String payAccount; // 买家账号（仅自有平台及线下平台返回）
    private String accountName; // 买家开户人姓名
    private String accountBank; // 开户银行
    private Boolean isAuto; // 是否系统自动生成
    private String remark; // 备注

    // getters & setters
}
