package com.sfa.job.domain.order.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.sfa.job.domain.order.dao.WdtSwapOrderDao;
import com.sfa.job.domain.order.entity.WdtSwapOrder;
import com.sfa.job.domain.order.mapper.WdtSwapOrderMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

@DS("Bi")
@Repository
public class WdtSwapOrderDaoImpl implements WdtSwapOrderDao {

    private static final int BATCH_SIZE = 1000;
    @Autowired
    private WdtSwapOrderMapper swapOrderMapper;

    @Override
    public void saveOrUpdateBatch(List<WdtSwapOrder> mergeList) {
        for (int i = 0; i < mergeList.size(); i += BATCH_SIZE) {
            int toIndex = Math.min(i + BATCH_SIZE, mergeList.size());
            List<WdtSwapOrder> batchLists = mergeList.subList(i, toIndex);
            swapOrderMapper.saveOrUpdateBatch(batchLists);
        }
    }
}
