package com.sfa.job.domain.order.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.sfa.job.domain.order.dao.WdtRefundOrderDetailDao;
import com.sfa.job.domain.order.entity.WdtRefundOrderDetail;
import com.sfa.job.domain.order.mapper.WdtRefundOrderDetailMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

@DS("Bi")
@Repository
public class WdtRefundOrderDetailDaoImpl implements WdtRefundOrderDetailDao {

    private static final int BATCH_SIZE = 1000;
    @Autowired
    private WdtRefundOrderDetailMapper wdtRefundOrderDetailMapper;

    @Override
    public void saveOrUpdateBatch(List<WdtRefundOrderDetail> mergeList) {
        for (int i = 0; i < mergeList.size(); i += BATCH_SIZE) {
            int toIndex = Math.min(i + BATCH_SIZE, mergeList.size());
            List<WdtRefundOrderDetail> batchLists = mergeList.subList(i, toIndex);
            wdtRefundOrderDetailMapper.saveOrUpdateBatch(batchLists);
        }
    }
}
