package com.sfa.job.service.order.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.http.HttpStatus;
import cn.hutool.json.JSONUtil;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.qimencloud.api.DefaultQimenCloudClient;
import com.qimencloud.api.QimenCloudClient;
import com.sfa.common.core.exception.ServiceException;
import com.sfa.common.core.utils.DateUtils;
import com.sfa.job.config.WdtQimenConfig;
import com.sfa.job.domain.order.dao.*;
import com.sfa.job.domain.order.entity.FinanceBaseProduct;
import com.sfa.job.domain.order.entity.WdtQimenOrderDetailPayTime;
import com.sfa.job.domain.order.entity.WdtQimenOrderPayTime;
import com.sfa.job.pojo.order.request.WdtSalesTradeQueryQueryWithDetailVo;
import com.sfa.job.pojo.order.response.*;
import com.sfa.job.pojo.response.CollectOrderLogDto;
import com.sfa.job.pojo.response.SyncOrderDetailDto;
import com.sfa.job.service.order.IWdtQimenOrderPayTimeSyncService;
import com.sfa.job.util.WdtQimenUtil;
import com.taobao.api.ApiException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;

/**
 * 旺店通订单Service业务层处理
 *
 * @author lvbencai
 * @date 2025年01月07日17:00:16
 */
@Slf4j
@Service
public class WdtQimenOrderPayTimeSyncServiceImpl implements IWdtQimenOrderPayTimeSyncService {
    @Autowired
    WdtQimenOrderDetailPayTimeDao orderDetailDao;
    @Autowired
    WdtQimenOrderPayTimeDao orderDao;

    @Autowired
    FinianceBaseProductDao baseProductDao;
    @Autowired
    FinanceBaseZbjTypeDao baseZbjTypeDao;
    @Autowired
    CollectOrderLogDao orderLogInfoDao;
    @Autowired
    CollectErrorLogDao errorInfoDao;
    @Autowired
    IProductDao productDao;

    @Autowired
    WdtQimenConfig wdtQimenConfig;

//    @Transactional(rollbackFor = Exception.class)
    @Override
    public SyncOrderDetailDto syncWdtQimenOrderByTradeNo(Date startTime, Date endTime, Integer syncType, String tradeNo, Long pageNo, Long pageSize) {
        WdtSalesTradeQueryQueryWithDetailVo request = new WdtSalesTradeQueryQueryWithDetailVo();
        String method = request.getApiMethodName();
        String serverUrl = wdtQimenConfig.getServerUrl();
        String appKey = wdtQimenConfig.getAppKey();
        String appSecret = wdtQimenConfig.getAppSecret();
        String wdtAppSecret = wdtQimenConfig.getWdtAppSecret();

        String wdtSalt = wdtAppSecret.split(":")[1];
        String wdtSecret = wdtAppSecret.split(":")[0];
        String wdtAppKey = wdtQimenConfig.getWdtAppKey();

        String targetAppSecret = wdtQimenConfig.getTargetAppSecret();

        String wdtSid = wdtQimenConfig.getWdtSid();

        Long totalPage = 1L;
        Integer totalCount = 1;

        // 查询只到数据查询完毕
        QimenCloudClient client = new DefaultQimenCloudClient(serverUrl, appKey, appSecret);
        WdtSalesTradeQueryQueryWithDetailVo.Params params = new WdtSalesTradeQueryQueryWithDetailVo.Params();
        params.setStartTime(DateUtil.formatDateTime(startTime));
        params.setEndime(DateUtil.formatDateTime(endTime));
        // 旺店通的页码从0开始，奇门从1开始  时间类型 1:修改时间 2:付款时间 默认1
        params.setTimeType(2);
        params.setTradeNo(tradeNo);
        request.setParams(params);

        WdtSalesTradeQueryQueryWithDetailVo.Pager pager = new WdtSalesTradeQueryQueryWithDetailVo.Pager();
        pager.setPageNo(pageNo);
        pager.setPageSize(pageSize);
        request.setPager(pager);

        // 查询数据
        String dateTime = DateUtil.formatDateTime(new Date());
        request.setDatetime(dateTime);
        request.putOtherTextParam("wdt3_customer_id", wdtSid);
        request.setTargetAppKey(targetAppSecret);
        request.setWdtAppkey(wdtAppKey);
        request.setWdtSalt(wdtSalt);
        request.setWdtSign(WdtQimenUtil.getQimenCustomWdtSign(request, wdtSecret));

        WdtSalesTradeQueryQueryWithDetailDto response = null;
        try {
            response = client.execute(request);
            log.info(response.getBody());
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
        if (ObjectUtils.isNotEmpty(response) && response.getFlag().equals("failure")) {
            log.error("奇门加载数据异常：" + response.getMessage() + response.getSubMessage() + URLUtil.decode(response.getRequestUrl()));
            throw new ServiceException("奇门加载数据异常：" + response.getMessage() + response.getSubMessage());
        }
        // 转换返回的json字符串结果
        String body = response.getBody();
        WdtQimenBodyDto wdtQimenBodyDto = JSONUtil.toBean(body, WdtQimenBodyDto.class);
        WdtQimenResponseDto wdtQimenResponseDto = wdtQimenBodyDto.getResponse();
        SyncOrderDetailDto detailDto = new SyncOrderDetailDto();
        detailDto.setMethod(method);
        return detailDto;
    }

    /**
     * 按照付款时间来同步旺店通订单
     *
     * @param startTime
     * @param endTime
     */
//    @Transactional(rollbackFor = Exception.class)
    @Override
    public SyncOrderDetailDto syncWdtQimenOrder(Date startTime, Date endTime, Integer syncType, Long pageSize) {
        SyncOrderDetailDto detailDto = new SyncOrderDetailDto();
        String batchNo = syncType + DateUtils.dateTimeNow() + Thread.currentThread().getId();
        WdtSalesTradeQueryQueryWithDetailVo request = new WdtSalesTradeQueryQueryWithDetailVo();
        String method = request.getApiMethodName();
        List<WdtQimenOrderPayTime> orderResult = new ArrayList<>();
        try {
            detailDto.setBatchNo(batchNo);
            detailDto.setStartTime(startTime);
            detailDto.setEndTime(endTime);
            detailDto.setPageNo(-1);
            CollectOrderLogDto collectOrderLog = orderLogInfoDao.selectOrderSyncLatest(syncType, method);

            // 调用新方法设置时间范围
            detailDto.setupTimeRange(60, collectOrderLog);
            startTime = detailDto.getStartTime();
            endTime = detailDto.getEndTime();

            // 调用查询旺店通接口api 获取最新日期前的2小时
            Date currentLatest = DateUtils.addHours(new Date(), -2);

            if (currentLatest.compareTo(startTime) < 0) {
                detailDto.setMessage(String.format("开始时间%s不能大于当前时间%s", DateUtil.formatDateTime(startTime), DateUtil.formatDateTime(currentLatest)));
                log.debug(String.format("开始时间%s不能大于当前时间%s", DateUtil.formatDateTime(startTime), DateUtil.formatDateTime(currentLatest)));
                return detailDto;
            }
            if (!detailDto.validateStartTime()) {
                return detailDto;
            }
            log.info("查询订单参数：开始时间{},结束时间{},当前页:{}", DateUtil.formatDateTime(startTime), DateUtil.formatDateTime(endTime), detailDto.getPageNo());
            String serverUrl = wdtQimenConfig.getServerUrl();
            String appKey = wdtQimenConfig.getAppKey();
            String appSecret = wdtQimenConfig.getAppSecret();
            String wdtAppSecret = wdtQimenConfig.getWdtAppSecret();

            String wdtSalt = wdtAppSecret.split(":")[1];
            String wdtSecret = wdtAppSecret.split(":")[0];
            String wdtAppKey = wdtQimenConfig.getWdtAppKey();

            String targetAppSecret = wdtQimenConfig.getTargetAppSecret();

            String wdtSid = wdtQimenConfig.getWdtSid();

            Long pageNo = 1L;
            Long totalPage = 1L;
            Integer totalCount = 1;
            do {
                // 查询只到数据查询完毕
                QimenCloudClient client = new DefaultQimenCloudClient(serverUrl, appKey, appSecret);
                WdtSalesTradeQueryQueryWithDetailVo.Params params = new WdtSalesTradeQueryQueryWithDetailVo.Params();
                params.setStartTime(DateUtil.formatDateTime(startTime));
                params.setEndime(DateUtil.formatDateTime(endTime));
                // 旺店通的页码从0开始，奇门从1开始  时间类型 1:修改时间 2:付款时间 默认1
                params.setTimeType(2);
                request.setParams(params);

                WdtSalesTradeQueryQueryWithDetailVo.Pager pager = new WdtSalesTradeQueryQueryWithDetailVo.Pager();
                pager.setPageNo(pageNo);
                pager.setPageSize(pageSize);
                request.setPager(pager);

                // 查询数据
                String dateTime = DateUtil.formatDateTime(new Date());
                request.setDatetime(dateTime);
                request.putOtherTextParam("wdt3_customer_id", wdtSid);
                request.setTargetAppKey(targetAppSecret);
                request.setWdtAppkey(wdtAppKey);
                request.setWdtSalt(wdtSalt);
                request.setWdtSign(WdtQimenUtil.getQimenCustomWdtSign(request, wdtSecret));

                WdtSalesTradeQueryQueryWithDetailDto response = client.execute(request);
                if (ObjectUtils.isNotEmpty(response) && response.getFlag().equals("failure")) {
                    log.error("奇门加载数据异常：" + response.getMessage() + response.getSubMessage() + URLUtil.decode(response.getRequestUrl()));
                    throw new ServiceException("奇门加载数据异常：" + response.getMessage() + response.getSubMessage());
                }
                // 转换返回的json字符串结果
                String body = response.getBody();
                WdtQimenOrderPayTimeBodyDto wdtQimenBodyDto = JSONUtil.toBean(body, WdtQimenOrderPayTimeBodyDto.class);
                WdtQimenOrderPayTimeResponseDto wdtQimenResponseDto = wdtQimenBodyDto.getResponse();
                WdtQimenOrderPayTimeDto wdtQimenDataDto = wdtQimenResponseDto.getData();

                totalCount = wdtQimenDataDto.getTotalCount();
                totalPage = totalCount / pager.getPageSize() + 1;

                List<WdtQimenOrderPayTime> orderSubResult = wdtQimenDataDto.getOrder();
                if (ObjectUtils.isEmpty(orderSubResult)) {
                    log.warn("当前查询没有数据，奇门加载数据异常：" + response.getMessage() + response.getSubMessage() + URLUtil.decode(response.getRequestUrl()));
//                    throw new ServiceException("旺店通没有查询到订单数据");
                }
                orderResult.addAll(orderSubResult);
                pageNo++;
            } while (pageNo <= totalPage);


            // 基础数据 直播间分类数据+成本、规格、口味
            Map<String, FinanceBaseProduct> baseProductMap = baseProductDao.selectBaseProduct();

            Map<String, String> baseZbjType = baseZbjTypeDao.selectBaseZbjType();
            // 系列
            Map<String, String> prodSeriesMap = productDao.selectProdSeries();

            // 入库订单表
            log.info("开始插入订单数据，数量：{}", orderResult.size());
            Date finalStartTime = startTime;
            Date finalEndTime = endTime;
            orderResult.forEach(order -> {
                order.setDelFlag(0);
                order.setBatchNo(batchNo);
                order.setStartTime(finalStartTime);
                order.setEndTime(finalEndTime);
                order.setSyncType(syncType);
                order.setCreateTime(new Date());
                order.setUpdateTime(new Date());
                order.setCreatedDate(new Date(Long.valueOf(order.getCreated())));
            });
            orderDao.saveOrUpdateBatch(orderResult);


            List<WdtQimenOrderDetailPayTime> mergeList = new ArrayList<>();
            // 用于同一个订单号，来赋值直播间信息
            Map<String, WdtQimenOrderDetailPayTime> orderZbjMap = new HashMap<>();
            // 入库订单明细表
            for (WdtQimenOrderPayTime order : orderResult) {
                List<WdtQimenOrderDetailPayTime> orderDetails = order.getDetailList();
                for (WdtQimenOrderDetailPayTime orderDetail : orderDetails) {
                    orderDetail.setSeries(prodSeriesMap.get(orderDetail.getGoodsNo()));
                    orderDetail.setTradeStatus(order.getTradeStatus());
                    orderDetail.setShopNo(order.getShopNo());
                    orderDetail.setShopName(order.getShopName());
                    orderDetail.setShopRemark(order.getShopRemark());
                    orderDetail.setReceivable(order.getReceivable());
                    orderDetail.setReceiverArea(order.getReceiverArea());
                    orderDetail.setConsignTime(order.getConsignTime());
                    orderDetail.setTradeTime(order.getTradeTime());
                    orderDetail.setBatchNo(batchNo);
                    orderDetail.setTradeNo(order.getTradeNo());
                    if (ObjectUtils.isEmpty(orderDetail.getPayTime())) {
                        orderDetail.setPayTime(order.getPayTime());
                    }
                    if(ObjectUtils.isEmpty(order.getPayTime())){
                        log.info("订单号：{}，订单明细支付时间为空，使用订单支付时间", orderDetail.getTradeNo());
                    }
                    orderDetail.setOrderPayTime(order.getPayTime());

                    // 计算分销信息
                    orderDetail.setFenxiaoNick(order.getFenxiaoNick());
                    orderDetail.setFenxiaoId(orderDetail.getFenxiaoId(order, orderDetail.getTradeId()));
                    orderDetail.setFenxiaoName(orderDetail.getFenxiaoName(order, orderDetail.getTradeId()));
                    orderDetail.setStartTime(finalStartTime);
                    orderDetail.setEndTime(finalEndTime);
                    orderDetail.setSyncType(syncType);
                    // 如果存在相同的
                    WdtQimenOrderDetailPayTime sameDetail = orderZbjMap.get(orderDetail.getSrcTid());

                    orderDetail.setZbjName(orderDetail.getFenxiaoName(), orderDetail.getRemark(), sameDetail);
                    orderDetail.setZbjId(orderDetail.getRemark(), sameDetail);
                    orderDetail.setZbjZbId(orderDetail.getFenxiaoId(), orderDetail.getRemark(), sameDetail);
                    orderDetail.setZbjSaleType(orderDetail.getRemark(), sameDetail);
                    // 确定分销商类型
                    orderDetail.setZbjQdType(orderDetail.getFenxiaoId(), orderDetail.getZbjZbId(), baseZbjType);
                    // 同一个订单id的，设置直播间类型信息也相同
                    if (ObjectUtils.isNotEmpty(orderDetail.getZbjName())) {
                        orderZbjMap.put(orderDetail.getSrcTid(), orderDetail);
                    }
                    orderDetail.setFlavorErp(ObjectUtils.isNotEmpty(baseProductMap.get(orderDetail.getGoodsNo())) ? baseProductMap.get(orderDetail.getGoodsNo()).getFlavor() : "");
                    orderDetail.setSpecNameErp(ObjectUtils.isNotEmpty(baseProductMap.get(orderDetail.getGoodsNo())) ? baseProductMap.get(orderDetail.getGoodsNo()).getSpec() : "");
                    // 将退款成功的数据分摊后总价置为0 2025年02月06日16:25:30
                    if (ObjectUtils.isNotEmpty(orderDetail.getRefundStatus()) && orderDetail.getRefundStatus().equals(5)) {
//                        orderDetail.setShareAmount(new BigDecimal(0));
                        orderDetail.setActualCost(new BigDecimal(0));
                        orderDetail.setStandardCost(new BigDecimal(0));
                        orderDetail.setSumActualCost(new BigDecimal(0));
                        orderDetail.setSumStandardCost(new BigDecimal(0));
                    } else {
                        orderDetail.setActualCost(ObjectUtils.isNotEmpty(baseProductMap.get(orderDetail.getGoodsNo())) ?
                                baseProductMap.get(orderDetail.getGoodsNo()).getActualCost() :
                                new BigDecimal(0)
                        );
                        orderDetail.setStandardCost(ObjectUtils.isNotEmpty(baseProductMap.get(orderDetail.getGoodsNo())) ?
                                baseProductMap.get(orderDetail.getGoodsNo()).getStandardCost() :
                                new BigDecimal(0)
                        );
                        orderDetail.setSumActualCost(orderDetail.getActualCost().multiply(orderDetail.getNum()));
                        orderDetail.setSumStandardCost(orderDetail.getStandardCost().multiply(orderDetail.getNum()));

                    }
                }
                mergeList.addAll(orderDetails);
            }
            log.info("开始插入订单详情数据，数量：{}", mergeList.size());

            // 批量插入
            orderDetailDao.saveOrUpdateBatch(mergeList);

            String remark = String.format("订单数量:%s,详情数量：%s", orderResult.size(), mergeList.size());
            log.info("插入订单和订单详情完成，批次{}开始时间{},结束时间{},订单数量:{},详情数量：{},下一次开始页数:{}", batchNo, DateUtil.formatDateTime(startTime),
                    DateUtil.formatDateTime(endTime), orderResult.size(), mergeList.size(), detailDto.getPageNo());
            detailDto.setDetailInfo(method, remark, syncType, orderResult.size(), mergeList.size(), totalCount, batchNo, endTime, startTime);
            orderLogInfoDao.insert(detailDto);
        } catch (Exception e) {
            detailDto.setCode(HttpStatus.HTTP_INTERNAL_ERROR);
            detailDto.setMessage(e.toString());
            log.error(e.getMessage(), e);
            // 记录错误日志表 collect_error_info
            errorInfoDao.insert(detailDto);
        }
        return detailDto;
    }




    @Override
    public SyncOrderDetailDto test( int year) {

        WdtQimenOrderPayTime order = new WdtQimenOrderPayTime();
        // 设置基本字段
        order.setTradeId(System.currentTimeMillis());
        order.setTradeNo("TEST_" + year + "_" + new Random().nextInt(10000));
        order.setShopId(1);
        order.setShopNo("SHOP001");
        order.setPlatformId(11);
        order.setShopName("测试店铺");
        order.setTradeStatus(10); // 未付款状态
        order.setTradeType(1); // 网店销售
//        order.setPayTime(LocalDateTimeUtil.now());

        order.setCreated(String.valueOf(System.currentTimeMillis()));
        order.setCreatedDate(new Date());
        order.setDelFlag(0);
        order.setCreateTime(new Date());
        order.setUpdateTime(new Date());
        order.setDeliveryTerm(1);
        order.setRefundStatus(1);
        order.setFenxiaoType(11);
        order.setBadReason(1);
        order.setGoodsTypeCount(new BigDecimal(1));
        order.setGoodsCount(new BigDecimal(1));
        order.setGoodsAmount(new BigDecimal(1));
        order.setPostAmount(new BigDecimal(1));
        order.setOtherAmount(new BigDecimal(1));
        order.setDiscount(new BigDecimal(1));
        order.setDiscount(new BigDecimal(1));
        order.setReceivable(new BigDecimal(1));
        order.setCodAmount(new BigDecimal(1));
        order.setExtCodFee(new BigDecimal(1));
        order.setGoodsCost(new BigDecimal(1));
        order.setPostCost(new BigDecimal(1));
        order.setWeight(new BigDecimal(1));
        order.setProfit(new BigDecimal(1));
        order.setTax(new BigDecimal(1));
        order.setTaxRate(new BigDecimal(1));
        order.setCommission(new BigDecimal(1));
        order.setInvoiceType(1);
        order.setTradeFrom(1);
        order.setRawGoodsCount(new BigDecimal(1));
        order.setRawGoodsTypeCount(1);
        order.setCurrency("CNY");

        order.setCreated("1");
        order.setCreatedDate(new Date());
        order.setTradeMask(1);
        order.setPackageCost(new BigDecimal(1));
        order.setPaid(new BigDecimal(1));
        order.setLargeType(1);
        order.setGiftMask(1);
        order.setOtherCost(new BigDecimal(1));
        order.setIsSealed(true);
        order.setCustomerType(1);
        order.setDelFlag(1);
        order.setUpdateTime(new Date());
        order.setBatchNo("TEST_" + year);


        // 设置不同年份的支付时间，这是分片的关键字段
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, 0, 1, 0, 0, 0);
        order.setPayTime(LocalDateTimeUtil.of(calendar.getTime()));

        log.info("插入" + year + "年订单，payTime: " + order.getPayTime());


        // 由于是测试环境，这里可能需要特殊处理批量保存
        // 注意：实际环境中应该使用业务层方法进行保存
        orderDao.saveOrUpdateBatch(java.util.Collections.singletonList(order));

        return null;
    }


}
