package com.sfa.job.domain.qince.entity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Data
@TableName("qince_user_statistic")
public class QinceUserStatistic implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID 唯一标识
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 部门名称
     */
    @TableField("dept_name")
    private String deptName;

    /**
     * 勤策用户ID
     */
    @TableField("qc_user_id")
    private Long qcUserId;

    /**
     * 性别
     */
    @TableField("sex")
    private String sex;

    /**
     * 用户名称
     */
    @TableField("user_name")
    private String userName;

    /**
     * 所属考勤组
     */
    @TableField(value = "`group`")
    private String group;

    /**
     * 用户工号
     */
    @TableField("employee_code")
    private String employeeCode;

    /**
     * 定位是否虚假模拟位置。0：非虚假模拟位置，1：虚假模拟位置
     */
    @TableField("check_in_attd_lie_locate")
    private Integer checkInAttdLieLocate;

    /**
     * 上班打卡位置
     */
    @TableField("check_in_attd_address")
    private String checkInAttdAddress;

    /**
     * 上班是否脱岗。0：正常，1：脱岗
     */
    @TableField("check_in_attd_lc_error")
    private Integer checkInAttdLcError;

    /**
     * 上班考勤状态。0：正常，1：迟到，2：异常
     */
    @TableField("check_in_attd_status")
    private Integer checkInAttdStatus;

    /**
     * 上班打卡时间
     */
    @TableField("check_in_attd_time")
    private LocalDateTime checkInAttdTime;

    /**
     * 考勤日期
     */
    @TableField("att_date")
    private LocalDate attDate;

    /**
     * 工作时长
     */
    @TableField("work_time")
    private Double workTime;

    /**
     * 备注信息
     */
    @TableField("remarks")
    private String remarks;

    /**
     * 下班定位是否虚假模拟位置。0：非虚假模拟位置，1：虚假模拟位置
     */
    @TableField("check_out_attd_lie_locate")
    private Integer checkOutAttdLieLocate;

    /**
     * 下班打卡位置
     */
    @TableField("check_out_attd_address")
    private String checkOutAttdAddress;

    /**
     * 下班是否脱岗。0：正常，1：脱岗
     */
    @TableField("check_out_attd_lc_error")
    private Integer checkOutAttdLcError;

    /**
     * 下班考勤状态。0：正常，1：迟到，2：异常
     */
    @TableField("check_out_attd_status")
    private Integer checkOutAttdStatus;

    /**
     * 下班考勤时间
     */
    @TableField("check_out_attd_time")
    private LocalDateTime checkOutAttdTime;

    /**
     * 删除标记。0：删除 1：正常
     */
    @TableField(value = "is_delete")
    private Integer isDelete = 1;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private LocalDateTime createTime;

    /**
     * 修改时间
     */
    @TableField(value = "modify_time")
    private LocalDateTime modifyTime;
}