package com.sfa.job.xxljob.order;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpStatus;
import com.alibaba.fastjson2.JSONObject;
import com.sfa.job.pojo.response.SyncOrderDetailDto;
import com.sfa.job.service.order.FinanceOrderSyncService;
import com.xxl.job.core.context.XxlJobContext;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author : 吕本才
 * @date : 2025-01-15 13:03:51
 * @describe : 财务订单数据
 */
@Component
@Slf4j
public class FinanceOrderTask {

    @Autowired
    FinanceOrderSyncService  financeOrderSyncService;

    /**
     * 同步部门数据
     */
    @XxlJob("syncWangdiantongOrderDetail")
    public SyncOrderDetailDto syncWangdiantongOrderDetail() {
        Long st = System.currentTimeMillis();
        // 暂不考虑分片
        XxlJobContext xxlJobContext = XxlJobContext.getXxlJobContext();
        int shardingTotalCount = xxlJobContext.getShardTotal();
        int shardingItem = xxlJobContext.getShardIndex();
        XxlJobHelper.log(">>>>>>>>>>syncWangdiantongOrderDetail Job start<<<<<<<<<<");

        // 简单模拟分片处理，这里输出每个分片的信息
        XxlJobHelper.log("分片总数: " + shardingTotalCount + ", 当前分片: " + shardingItem);
        XxlJobHelper.log("xxl-job开始同步-旺店通订单明细api接口数据");

        // 定时任务不设定开始时间和结束时间
        SyncOrderDetailDto detailDto = financeOrderSyncService.syncWdtOrder(null, null,0);
        XxlJobHelper.log("xxl-job结束同步-旺店通订单明细api接口数据, 共同步订单{}条数据，订单明细{}条,订单批次号：{},订单的开始时间{}和结束时间{}",
                detailDto.getOrderCount(),detailDto.getOrderDetailCount(),detailDto.getBatchNo(),
                DateUtil.formatDateTime(detailDto.getStartTime()),DateUtil.formatDateTime(detailDto.getEndTime()) );
        if(ObjectUtil.equals(HttpStatus.HTTP_OK,detailDto.getCode()) ){
            XxlJobHelper.handleSuccess(JSONObject.toJSONString(detailDto));
        }else{
            XxlJobHelper.handleFail(detailDto.getMessage());
        }
         return detailDto;
    }
    /**
     * 同步部门数据
     */
    @XxlJob("syncWdtRefundOrder")
    public SyncOrderDetailDto syncWdtRefundOrder() {
        Long startTime = System.currentTimeMillis();
        // 暂不考虑分片
        XxlJobContext xxlJobContext = XxlJobContext.getXxlJobContext();
        int shardingTotalCount = xxlJobContext.getShardTotal();
        int shardingItem = xxlJobContext.getShardIndex();
        XxlJobHelper.log(">>>>>>>>>>syncWangdiantongOrderDetail Job start<<<<<<<<<<");

        // 简单模拟分片处理，这里输出每个分片的信息
        XxlJobHelper.log("分片总数: " + shardingTotalCount + ", 当前分片: " + shardingItem);
        XxlJobHelper.log("xxl-job开始同步-旺店通订单明细api接口数据");

        // 定时任务不设定开始时间和结束时间
        SyncOrderDetailDto detailDto = financeOrderSyncService.syncWdtRefundOrder(null, null,0);
        Long endTime = System.currentTimeMillis();
        XxlJobHelper.log("xxl-job结束同步-旺店通订单明细api接口数据, 共同步订单{}条数据，订单明细{}条,订单批次号：{},订单的开始时间{}和结束时间{},时长：{}",
                detailDto.getOrderCount(),detailDto.getOrderDetailCount(),detailDto.getBatchNo(),
                DateUtil.formatDateTime(detailDto.getStartTime()),DateUtil.formatDateTime(detailDto.getEndTime()),
                endTime-startTime);
        if(ObjectUtil.equals(HttpStatus.HTTP_OK,detailDto.getCode()) ){
            XxlJobHelper.handleSuccess(JSONObject.toJSONString(detailDto));
        }else{
            XxlJobHelper.handleFail(detailDto.getMessage());
        }
        return detailDto;
    }
}
