package com.sfa.job.domain.order.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;



/**
 * 退换货订单数据
 * @author lvbencai
 * @date 2025-02-28 12:26:29
 */
@Data
@TableName(value = "wdt_swap_order")
public class WdtSwapOrder {
    private String tid; // 换出订单原始单号
    private String shopNo; // 店铺编号
    private String shopName; // 店铺名称
    private String warehouseNo; // 仓库名称
    private Integer shopId; // 店铺id
    private Integer warehouseId; // 仓库id
    private Integer swapProvince; // 省份id
    private Integer swapCity; // 城市id
    private String swapArea; // 地区
    private Integer swapDistrict; // 地区id
    private Integer swapLogisticsId; // 换货新订单物流公司id
    private BigDecimal postAmount; // 换货邮费
    private BigDecimal otherAmount; // 其他金额
    private List<WdtSwapOrderDetail> swapOrderDetailList; // 换出订单明细

    // getters & setters
}
