package com.sfa.job.domain.order.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 退换货订单数据
 * @author lvbencai
 * @date 2025-02-28 12:26:29
 */
@Data
@TableName(value = "wdt_refund_order")
public class WdtRefundOrder {
    private Integer refundId; // 退换单id
    private String srcTids; // 原始单号(关联的销售单平台订单号)
    private String refundNo; // 退换单号
    private String remark; // 备注
    private Integer type; // 退换单类型 1:售前退款;2:退货;3:换货;4:退款不退货;6:保价退款
    private Integer stockinStatus; // 入库状态 0:无需入库;1:待入库;2:部分入库;3:全部入库;4:终止入库
    private String flagName; // 标记名称
    private BigDecimal returnGoodsCount; // 退回货品数量
    private String receiverTelno; // 退款订单中收件人电话（仅自有平台及线下平台返回）
    private String receiverName; // 退款订单中收件人姓名（仅自有平台及线下平台返回）
    private String modified; // 修改时间
    private Integer noteCount; // 便签数量
    private String shopNo; // 店铺编号
    private Integer fromType; // 建单方式 0:API抓单;1:手工建单;2:Excel导入;3:分销商推送
    private String created; // 建单时间
    private String settleTime; // 结算时间
    private String checkTime; // 审核时间
    private String returnLogisticsNo; // 退货物流单号
    private String tradeNoList; // 系统订单号列表
    private BigDecimal guaranteeRefundAmount; // 平台退款金额(担保退款金额)
    private BigDecimal returnGoodsAmount; // 退货金额
    private String returnLogisticsName; // 物流公司名称
    private String reasonName; // 退换说明
    private String refundReason; // 退款原因
    private String buyerNick; // 客户网名（仅自有平台及线下平台返回）
    private String operatorName; // 建单者
    private BigDecimal actualRefundAmount; // 实际退款金额
    private String revertReasonName; // 驳回原因
    private String returnWarehouseNo; // 退回仓库编号
    private BigDecimal directRefundAmount; // 线下退款金额(非担保退款金额)
    private BigDecimal receiveAmount; // 收款金额
    private String customerName; // 客户姓名（仅自有平台及线下平台返回）
    private String fenxiaoNickName; // 分销商昵称
    private Integer status; // 退换单状态 10:已取消;20:待审核;30:已审核...
    private Integer shopId; // 店铺id
    private Integer tradeId; // 订单id
    private String rawRefundNos; // 原始退换单号
    private String payId; // 支付订单号
    private String providerRefundNo; // 分销退换单号
    private Integer shopPlatformId; // 店铺平台id
    private String tidList; // 原始单号
    private Integer subPlatformId; // 子平台id
    private Integer returnWarehouseId; // 退回仓库id
    private Integer platformId; // 平台id
    private String wmsOwnerNo; // 奇门货主编号
    private Integer warehouseType; // 退回仓库类型
    private Integer badReason; // 拦截原因
    private String modifiedDate; // 最后修改时间
    private String returnMaskInfo; // 退换信息
    private Integer processStatus; // 处理状态
    private Integer reasonId; // 退款原因id
    private Integer revertReason; // 驳回原因id
    private Integer customerId; // 客户id
    private Integer consignMode; // 发货方式
    private String refundTime; // 退款创建时间
    private String fenxiaoTid; // 分销原始单号
    private String fenxiaoNickNo; // 分销商编码
    private String wmsCode; // wms单号
    private Integer rrStatus; // 平台状态
    private String currentPhaseTimeout; // 退款成功时间
    private List<WdtRefundOrderDetail> detailList; // 退换单详情
    private List<WdtRefundAmountDetail> amountDetailList; // 金额明细
    private WdtSwapOrder swapOrder; // 换出订单
}
