package com.sfa.job.domain.order.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.job.domain.order.dao.CollectOrderLogDao;
import com.sfa.job.domain.order.entity.CollectOrderLog;
import com.sfa.job.domain.order.mapper.CollectOrderLogMapper;
import com.sfa.job.pojo.response.CollectOrderLogDto;
import com.sfa.job.pojo.response.SyncOrderDetailDto;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

@DS("bi")
@Repository
public class CollectOrderLogDaoImpl implements CollectOrderLogDao {

    @Autowired
    private CollectOrderLogMapper logInfoMapper;

    @Override
    public void insert(SyncOrderDetailDto detailDto) {
        CollectOrderLog collectOrderLog = new CollectOrderLog();
        collectOrderLog.setSyncType(detailDto.getSyncType());
        collectOrderLog.setMethod(detailDto.getMethod());
        collectOrderLog.setOrderCount(detailDto.getOrderCount());
        collectOrderLog.setOrderDetailCount(detailDto.getOrderDetailCount());
        collectOrderLog.setBatchNo(detailDto.getBatchNo());
        collectOrderLog.setLatestTime(detailDto.getLatestTime() );
        collectOrderLog.setPageNo(detailDto.getPageNo());
        collectOrderLog.setTotalCount(detailDto.getTotalCount());
        logInfoMapper.insert(collectOrderLog);
    }

    @Override
    public CollectOrderLogDto selectOrderSyncLatest(Integer syncType) {
        // 查询最新发货日期
        List<CollectOrderLog> orderList = logInfoMapper.selectList(
                new LambdaQueryWrapper<CollectOrderLog>()
                        // 默认查询xxljob自动同步时间
                        .eq(CollectOrderLog::getSyncType,syncType)
                        .eq(CollectOrderLog::getDelFlag,0)
                        .orderByDesc(CollectOrderLog::getUpdateTime)
                        .last("LIMIT 1"));
        if(ObjectUtils.isNotEmpty(orderList)){
            // 最新的数据日期
            CollectOrderLog collectOrderLog = orderList.get(0);
            return BeanUtils.transitionDto(collectOrderLog, CollectOrderLogDto.class);
        }
        return null;
    }


}
