package com.sfa.job.controller.order;

import com.sfa.job.pojo.response.SyncOrderDetailDto;
import com.sfa.job.service.order.WdtQimenOrderSyncService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;


/**
 * @author : liqiulin
 * @date : 2025-07-08 13
 * @describe : 订单 - 发货单物流查询
 */
@RestController
@RequestMapping("/order/qimen")
public class WdtQimenOrderController {

    @Autowired
    private WdtQimenOrderSyncService orderQimenSyncService;


    @GetMapping("/sync")
    public Object sync(@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")Date startTime,
                       @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") Date endTime,
                       @RequestParam(value = "pageSize", required = false, defaultValue = "200") Long pageSize
    ) {
        SyncOrderDetailDto syncOrderDetailDto = orderQimenSyncService.syncWdtQimenOrder(startTime, endTime, 1, pageSize);
        return syncOrderDetailDto;
    }

}
