package com.sfa.job.domain.order.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.sfa.job.domain.order.dao.WdtQimenOrderDao;
import com.sfa.job.domain.order.entity.WdtQimenOrder;
import com.sfa.job.domain.order.mapper.WdtQimenOrderMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

@DS("bi")
@Repository
public class WdtQimenOrderDaoImpl implements WdtQimenOrderDao {

    private static final int BATCH_SIZE = 1000;
    @Autowired
    private WdtQimenOrderMapper wdtQimenOrderMapper;

    @Override
    public void saveOrUpdateBatch(List<WdtQimenOrder> mergeList) {
        for (int i = 0; i < mergeList.size(); i += BATCH_SIZE) {
            int toIndex = Math.min(i + BATCH_SIZE, mergeList.size());
            List<WdtQimenOrder> batchLists = mergeList.subList(i, toIndex);
            wdtQimenOrderMapper.saveOrUpdateBatch(batchLists);
        }
    }
}
