package com.sfa.job.service.feishu;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.sfa.job.domain.use.dao.IFeishuSheetRecordDao;
import com.sfa.job.enums.FSRecordEnum;
import com.sfa.job.pojo.response.FeishuSheetRecordDto;
import com.sfa.job.util.FeiShuUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.stream.DoubleStream;

/**
 * @author : liqiulin
 * @date : 2025-05-09 16
 * @describe :
 */
@Service
public class PullSheetServiceImpl implements IPullSheetService{

    @Autowired
    private IFeishuSheetRecordDao feishushetRecordDao;
    @Autowired
    private FeiShuUtil feiShuUtil;

    /**
     * 拉取表格 - 勤策门店的城市经理、省区经理、大区总监
     * https://wangxiaolu.feishu.cn/sheets/I076slXhlhY2RdtDetEc17ornYd?sheet=49e4ba
     */
    @Override
    public void qinceSotreManage() {
        FeishuSheetRecordDto recordDto = feishushetRecordDao.selectOne(FSRecordEnum.XS_USER_RELATION.getType());
        JSONObject jsonObject = feiShuUtil.pullSheetOneRange(recordDto.getSheetToken(), feiShuUtil.getBotToken1(), recordDto.getRanges());
        JSONArray values = jsonObject.getJSONArray("values");
        // 创建逻辑构架人员关系表
        // 创建逻辑构架人员关系对象
        // 遍历values数组，获取每个对象的values数组

        values.forEach(item -> {
            JSONArray jsonArray = (JSONArray) item;

        });
    }
}
