package com.sfa.job.domain.order.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.sfa.job.domain.order.dao.WdtQimenOrderDetailDao;
import com.sfa.job.domain.order.entity.WdtQimenOrderDetail;
import com.sfa.job.domain.order.mapper.WdtQimenOrderDetailMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

@DS("bi")
@Repository
public class WdtQimenOrderDetailDaoImpl implements WdtQimenOrderDetailDao {

    private static final int BATCH_SIZE = 1000;
    @Autowired
    private WdtQimenOrderDetailMapper wdtQimenOrderDetailMapper;

    @Override
    public void saveOrUpdateBatch(List<WdtQimenOrderDetail> mergeList) {
        for (int i = 0; i < mergeList.size(); i += BATCH_SIZE) {
            int toIndex = Math.min(i + BATCH_SIZE, mergeList.size());
            List<WdtQimenOrderDetail> batchLists = mergeList.subList(i, toIndex);
            wdtQimenOrderDetailMapper.saveOrUpdateBatch(batchLists);
        }
    }


}
