package com.sfa.job.domain.order.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.sfa.job.domain.order.dao.WdtQimenOrderPayTimeDao;
import com.sfa.job.domain.order.entity.WdtQimenOrderPayTime;
import com.sfa.job.domain.order.mapper.WdtQimenOrderPayTimeMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

@DS("sharding")
@Repository
public class WdtQimenOrderPayTimeDaoImpl implements WdtQimenOrderPayTimeDao {

    private static final int BATCH_SIZE = 1000;
    @Autowired
    private WdtQimenOrderPayTimeMapper wdtQimenOrderPayTimeMapper;

    @DS("sharding")
    @Override
    public void saveOrUpdateBatch(List<WdtQimenOrderPayTime> mergeList) {
        for (int i = 0; i < mergeList.size(); i += BATCH_SIZE) {
            int toIndex = Math.min(i + BATCH_SIZE, mergeList.size());
            List<WdtQimenOrderPayTime> batchLists = mergeList.subList(i, toIndex);
            wdtQimenOrderPayTimeMapper.saveOrUpdateBatch(batchLists);
        }
    }
}
