package com.sfa.job;

import com.sfa.common.security.annotation.EnableCustomConfig;
import com.sfa.common.security.annotation.EnableRyFeignClients;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;

/**
 * 定时任务
 *
 * @author ruoyi
 */
@ComponentScan(basePackages = {"com.sfa.common.core.utils.sdk","com.sfa.job"})
@EnableCustomConfig
@EnableRyFeignClients
@SpringBootApplication
@MapperScan("com.sfa.job.domain.*.mapper")
public class SfaJobApplication
{
    public static void main(String[] args) {
        SpringApplication.run(SfaJobApplication.class, args);
    }
}
