package com.sfa.job.util;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.HashMap;

/**
 * @author : liqiulin
 * @date : 2025-06-19 17
 * @describe : T100接口对接
 */
@Slf4j
@Component
public class T100Util {

    @Value("${t100.url}")
    private String url;

    @Value("${t100.ent_id}")
    private String entId;

    public void createOrUpdateDept(JSONObject deptJson){
        JSONObject datakey = new JSONObject();
        datakey.put("CompanyId","BJHQ");
        datakey.put("EntId",entId);
        deptJson.put("datakey",datakey);

        HashMap<String,String> header = new HashMap<>();
        header.put("Content-Type","application/json;charset=utf-8");
        header.put("digi-protocol","raw");
        header.put("digi-srvver","1.0");
        header.put("digi-srvcode","000");
        header.put("digi-type","syndd c");
        header.put("digi-key","f63b06af224e90ea3f9f08e0226fc91e");
        log.info("T100-AU-DEPT参数：{}",deptJson);
        String body = HttpUtil.createPost(url).addHeaders(header).body(deptJson.toString()).execute().body();
        String msg = body.replaceAll("\n", "");
        log.info("T100-AU-DEPT结果：{}",msg);
    }

    public void createOrUpdateUser(JSONObject userJson) {
        JSONObject datakey = new JSONObject();
        datakey.put("CompanyId","BJHQ");
        datakey.put("EntId",entId);
        userJson.put("datakey",datakey);

        HashMap<String,String> header = new HashMap<>();
        header.put("Content-Type","application/json;charset=utf-8");
        header.put("digi-protocol","raw");
        header.put("digi-srvver","1.0");
        header.put("digi-srvcode","000");
        header.put("digi-type","sync");
        header.put("digi-key","f63b06af224e90ea3f9f08e0226fc91e");
        log.info("T100-AU-USER参数：{}",userJson);
        String body = HttpUtil.createPost(url).addHeaders(header).body(userJson.toString()).execute().body();
        String msg = body.replaceAll("\n", "");
        log.info("T100-AU-USER结果：{}",msg);

    }
}
