package com.sfa.job.domain.system.dao;

import com.alibaba.fastjson2.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.sfa.common.core.enums.StatusType;
import com.sfa.job.domain.system.entity.SysDept;
import com.sfa.job.domain.system.mapper.SysDeptMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2024-12-09 13
 * @describe :
 */
@Service
@DS("master")
public class SysDeptDaoImpl implements ISysDeptDao{
    @Autowired
    SysDeptMapper sysDeptMapper;

    /**
     * 插入或更新部门信息
     */
    @Override
    public SysDept insertOrUpdate(JSONObject jo,SysDept parentDept) {
        SysDept sysDept = new SysDept();
        sysDept.setCreateBy("admin");
        sysDept.setCreateUserId(1L);
        sysDept.setUpdateBy("admin");
        sysDept.setUpdateUserId(1L);

        String departmentId = jo.getString("department_id");
        sysDept.setDeptCode(departmentId);

        String name = jo.getString("name");
        sysDept.setDeptName(name);

        String openDepartmentId = jo.getString("open_department_id");
        sysDept.setFsDeptId(openDepartmentId);

        sysDept.setParentId(parentDept.getDeptId());
        sysDept.setParentCode(parentDept.getDeptCode());
        sysDept.setParentName(parentDept.getDeptName());
        sysDept.setParentFsId(parentDept.getFsDeptId());

        if (StringUtils.isBlank(parentDept.getAncestors())){
            sysDept.setAncestors(parentDept.getDeptId()+"");
        }else {
            sysDept.setAncestors(parentDept.getAncestors()+","+parentDept.getDeptId());
        }

        if (StringUtils.isBlank(parentDept.getAncestorNames())){
            sysDept.setAncestorNames(parentDept.getDeptName()+"");
        }else {
            sysDept.setAncestorNames(parentDept.getAncestorNames()+","+parentDept.getDeptName());
        }

        String order = jo.getString("order");
        sysDept.setOrderNum(Integer.parseInt(order));

        if (jo.containsKey("leaders")){
            Map leader = (Map) jo.getJSONArray("leaders").get(0);
            sysDept.setFsLeaderId(leader.get("leaderID").toString());
        }

        Integer memberCount = jo.getInteger("primary_member_count");
        sysDept.setMemberCount(memberCount);

        Boolean statusB = jo.getJSONObject("status").getBoolean("is_deleted");
        sysDept.setStatus(statusB?"1":"0");
        sysDeptMapper.insertOrUpdate(sysDept);
        return sysDept;
    }

    /**
     * 根据部门编码查询部门信息
     * @param deptCode 0时默认查询根部门信息
     */
    @Override
    public SysDept selectByDeptCode(String deptCode) {
        SysDept sysDept = null;
        if ("0".equals(deptCode)){
            sysDept = sysDeptMapper.selectById(1);

        }else {
            sysDept = sysDeptMapper.selectOne(new LambdaQueryWrapper<SysDept>().eq(SysDept::getDeptCode, deptCode).eq(SysDept::getStatus, StatusType.VALID.getType() + ""));
        }
        return sysDept;
    }

    /**
     * 查询有效的部门列表
     */
    @Override
    public List<SysDept> selectListByStatus() {
        return sysDeptMapper.selectListByStatus();
    }
}
