package com.sfa.job.domain.order.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.sfa.job.domain.order.dao.WdtSwapOrderDetailDao;
import com.sfa.job.domain.order.entity.WdtSwapOrderDetail;
import com.sfa.job.domain.order.mapper.WdtSwapOrderDetailMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

@DS("bi")
@Repository
public class WdtSwapOrderDetailDaoImpl implements WdtSwapOrderDetailDao {

    private static final int BATCH_SIZE = 1000;
    @Autowired
    private WdtSwapOrderDetailMapper swapOrderDetailMapper;

    @Override
    public void saveOrUpdateBatch(List<WdtSwapOrderDetail> mergeList) {
        for (int i = 0; i < mergeList.size(); i += BATCH_SIZE) {
            int toIndex = Math.min(i + BATCH_SIZE, mergeList.size());
            List<WdtSwapOrderDetail> batchLists = mergeList.subList(i, toIndex);
            swapOrderDetailMapper.saveOrUpdateBatch(batchLists);
        }
    }
}
