package com.sfa.job.domain.order.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.sfa.job.domain.order.dao.WdtRefundOrderDao;
import com.sfa.job.domain.order.entity.WdtRefundOrder;
import com.sfa.job.domain.order.mapper.WdtRefundOrderMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

@DS("bi")
@Repository
public class WdtRefundOrderDaoImpl implements WdtRefundOrderDao {

    private static final int BATCH_SIZE = 1000;
    @Autowired
    private WdtRefundOrderMapper wdtRefundOrderMapper;

    @Override
    public void saveOrUpdateBatch(List<WdtRefundOrder> mergeList) {
        for (int i = 0; i < mergeList.size(); i += BATCH_SIZE) {
            int toIndex = Math.min(i + BATCH_SIZE, mergeList.size());
            List<WdtRefundOrder> batchLists = mergeList.subList(i, toIndex);
            wdtRefundOrderMapper.saveOrUpdateBatch(batchLists);
        }
    }
}
