package com.sfa.job.domain.order.dao.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.sfa.job.constants.Constants;
import com.sfa.job.domain.order.dao.CollectErrorLogDao;
import com.sfa.job.domain.order.entity.CollectErrorLog;
import com.sfa.job.domain.order.mapper.CollectErrorLogMapper;
import com.sfa.job.pojo.response.SyncOrderDetailDto;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.Date;

@DS("bi")
@Repository
public class CollectErrorLogImpl implements CollectErrorLogDao {

    @Autowired
    private CollectErrorLogMapper collectErrorLogMapper;

    @Override
    public void insert(SyncOrderDetailDto detailDto) {
        // 记录错误日志表 collect_error_info
        CollectErrorLog errorInfo = new CollectErrorLog();
        errorInfo.setBatchNo(detailDto.getBatchNo());
        errorInfo.setType(Constants.SYNC_TYPE_XXL_JOB);
        errorInfo.setErrorMsg(ObjectUtil.isNotEmpty(detailDto.getMessage())? StringUtils.substring(detailDto.getMessage(),0,2000):"");
        errorInfo.setEndTime(detailDto.getEndTime());
        errorInfo.setStartTime(detailDto.getStartTime());
        errorInfo.setCollectTime(new Date());
        collectErrorLogMapper.insert(errorInfo);
    }


}
