package com.sfa.job.domain.qince.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import lombok.Data;

/**
 * 勤策-客户管理-终端
 * @TableName qince_clientele_store
 */
@TableName(value ="qince_clientele_store")
@Data
public class QinceClienteleStore implements Serializable {
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 勤策的门店唯一ID
     */
    private String qcId;

    /**
     * 创建人id，来源勤策员工唯一ID
     */
    private String creatorWaiqinId;

    /**
     * 创建人名称
     */
    private String creatorName;

    /**
     * 系统名称
     */
    private String lineName;

    /**
     * 门店名称
     */
    private String storeName;

    /**
     * 门店编码
     */
    private String storeCode;

    /**
     * 门店经理,多门店经理名称间以“,”分隔
     */
    private String storeManager;

    /**
     * 门店类型名称
     */
    private String storeType;

    /**
     * 是否连锁；是/否
     */
    private String chain;

    /**
     * 勤策门店所属部门ID
     */
    private String storeDeptWaiqin365Id;

    /**
     * 门店部门名称
     */
    private String storeDeptName;

    /**
     * 是否双T门店
     */
    private String bothT;

    /**
     * 门店所属行政区域-省份名称，如：北京市、江苏省
     */
    private String storeMssProvince;

    /**
     * 门店所属行政区域-城市名称，如：南京市
     */
    private String storeMssCity;

    /**
     * 门店所属行政区域-区县名称，如：鼓楼区
     */
    private String storeMssArea;

    /**
     * 门店所属行政区域-乡镇街道名称，如：宁海路街道
     */
    private String storeMssStreet;

    /**
     * 门店所在地址
     */
    private String storeAddr;

    /**
     * 店铺经纬度
     */
    private String coordinates;

    /**
     * 合作状态编码。0：终止合作，1：合作中，2：未合作，3：有意向
     */
    private String storeCooperateStatus;

    /**
     * 门店分层标签名称。多分层标签名称以“,”分隔
     */
    private String storeLabel;

    /**
     * 门店分层标签id。多分层标签id以“,”分隔
     */
    private String storeLabelId;

    /**
     * 是否直接交易客户。0：是，1：否
     */
    private String storeSaleDirect;

    /**
     * 门店修改时间。格式：yyyy-MM-dd HH:mm:ss
     */
    private String storeModifyTime;

    /**
     * 门店修改人名称
     */
    private String storeModifyierName;

    /**
     * 创建方式
     */
    private String storeSourceType;

    /**
     * 门店门头照信息，多个以“,”号隔开
     */
    private String storePictures;

    /**
     * 门店客户经理编码，即为员工登录账号，多客户经理唯一标识间以英文“,”隔开
     */
    private String storeManagerCode;

    /**
     * 创建人编码
     */
    private String storeCreatorCode;

    /**
     * 修改人编码，取最新修改记录操作人
     */
    private String storeModifierCode;

    /**
     * 门店审批状态。1：待审批，2：审批打回，3：审批通过
     */
    private String storeApprovalStatus;

    /**
     * 门店删除状态。0：删除，1：正常
     */
    private String storeStatus;

    /**
     * 创建日期。格式：yyyy-MM-dd HH:mm:ss
     */
    private String createTime;

    /**
     * 
     */
    private String dealersName;

    /**
     * 经销商编码
     */
    private String dealerId;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}