package com.sfa.job.service.qince.impl;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sfa.job.domain.feishu.dao.IQinceMarketEmployeeDao;
import com.sfa.job.domain.qince.dao.IQinceClienteleStoreDao;
import com.sfa.job.domain.qince.dao.IQinceDealerDao;
import com.sfa.job.domain.system.dao.ISysDeptDao;
import com.sfa.job.domain.system.dao.ISysUserDao;
import com.sfa.job.pojo.feishu.response.QinceMarketEmployeeDto;
import com.sfa.job.pojo.qince.response.QinceClienteleStoreDto;
import com.sfa.job.pojo.qince.response.QinceDealerDto;
import com.sfa.job.service.qince.IQinceDealerQueryService;
import com.sfa.job.util.QinCeUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.groovy.util.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author : liqiulin
 * @date : 2025-04-24 16
 * @describe :
 */
@Slf4j
@Service
public class QinceDealerQueryServiceImpl implements IQinceDealerQueryService {

    @Autowired
    private IQinceDealerDao qinceDealerDao;
    @Autowired
    private IQinceClienteleStoreDao qinceClienteleStoreDao;
    @Autowired
    private IQinceMarketEmployeeDao qinceMarketEmployeeDao;
    @Autowired
    private ISysDeptDao sysDeptDao;
    @Autowired
    private ISysUserDao sysUserDao;
    @Autowired
    private QinCeUtils qinCeUtils;

    @Override
    public void updateQinceDealerInfo() {
        /**
         * 1. 查询今日新增/修改的经销商
         */
        List<QinceMarketEmployeeDto> mDtos = qinceMarketEmployeeDao.selectByTodayUpdate();
        if (CollectionUtils.isEmpty(mDtos)){
            log.info("push qc 经销商（架构）: 今日无新增/修改经销商");
            return;
        }

        // 查询部门Map<部门编码，部门名称>，人员Map<工号，姓名>
        Map<String,String> deptMap = sysDeptDao.getDeptCodeAndNameMap();
        Map<String,String> userMap = sysUserDao.getUserNoAndNameMap();

        /**
         * 2. 反写勤策中的自定义字段：大区、战区
         */
        for (QinceMarketEmployeeDto mDto : mDtos) {
            try {
                Map<String, Object> ext1 = new HashMap<>();
                ext1.put("dealer_ext_key", "大区");
                ext1.put("dealer_ext_value", deptMap.get(mDto.getDqDeptCode()));

                Map<String, Object> ext2 = new HashMap<>();
                ext2.put("dealer_ext_key", "战区");
                ext2.put("dealer_ext_value", deptMap.get(mDto.getZqDeptCode()));

                Map<String, Object> params = new HashMap<>();
                params.put("dealer_id", mDto.getDealerCode());
                params.put("exts", Arrays.asList(ext1, ext2));


                String url = qinCeUtils.builderUrl(QinCeUtils.MODIFY_DEALER, params);
                qinCeUtils.postQC(url, params);
                log.info("push qc 经销商（架构）success：{}：{}", mDto.getDealerName(), JSONObject.toJSONString(params));

                // 3. 反写当前经销商所负责门店信息：城市经理、战区经理、大区总监
                List<QinceClienteleStoreDto> storeDtoList = qinceClienteleStoreDao.findListByDealerId(mDto.getDealerCode());
                pushQinceStoreInfo(storeDtoList, deptMap.get(mDto.getDqDeptCode()), deptMap.get(mDto.getZqDeptCode()), mDto, userMap);
                log.info("push qc 终端（架构/负责人）success：{}", storeDtoList.size());

            } catch (RuntimeException e) {
                log.error("更新经销商失败：{}", JSONObject.toJSONString(mDto));
                log.error("失败原因：{}", e.getMessage());
            } catch (Exception e) {
                log.error("更新经销商失败：{}", e.getMessage());
            }
        }
    }

    /**
     * 暂停开发
     */
    @Override
    public void queryCusVisitRecord() {
        try {
            // 获取t-1日期
            String queryDate = DateUtil.yesterday().toString(DatePattern.NORM_DATE_PATTERN);
            Map<String, Object> params = qinCeUtils.queryCusVisitRecordParams(queryDate);
            String url = qinCeUtils.builderUrl(QinCeUtils.QUERY_CUS_VISIT_RECORD, params);
            JSONArray recordsJson = qinCeUtils.postArray(url, params);
        } catch (Exception e) {
            log.error("查询城市经理客户拜访失败：{}", e.getMessage());
        }

    }

    @Override
    public void updateQinceStore() {
        // 查询昨日新增终端
        String yesterday = DatePattern.NORM_DATE_FORMAT.format(DateUtil.yesterday());
        List<QinceClienteleStoreDto> storeDtoList = qinceClienteleStoreDao.findListByCreateDate(yesterday);
        if (CollectionUtils.isEmpty(storeDtoList)){
            log.info("push qc 终端（架构/负责人）: 今日无新增终端");
        }
        Map<String, List<QinceClienteleStoreDto>> groupStores = storeDtoList.stream().collect(Collectors.groupingBy(QinceClienteleStoreDto::getDealerId));

        // 查询新增终端涉及所有经销商，查询部门Map<部门编码，部门名称>，人员Map<工号，姓名>
        List<QinceMarketEmployeeDto> mDtos = qinceMarketEmployeeDao.selectByDealerCodes(groupStores.keySet());
        Map<String, QinceMarketEmployeeDto> dealerMap = mDtos.stream().collect(Collectors.toMap(dto -> dto.getDealerCode(), dto -> dto));

        Map<String,String> deptMap = sysDeptDao.getDeptCodeAndNameMap();
        Map<String,String> userMap = sysUserDao.getUserNoAndNameMap();

        for (Map.Entry<String, List<QinceClienteleStoreDto>> storesEntry : groupStores.entrySet()) {
            QinceMarketEmployeeDto mDto = dealerMap.get(storesEntry.getKey());
            List<QinceClienteleStoreDto> stores = storesEntry.getValue();
            pushQinceStoreInfo(stores, deptMap.get(mDto.getDqDeptCode()), deptMap.get(mDto.getZqDeptCode()), mDto, userMap);
            log.info("push qc 终端（架构/负责人）success：{}：{}", mDto.getDealerName(),storeDtoList.size());
        }
    }

    private void pushQinceStoreInfo(List<QinceClienteleStoreDto> storeDtoList,String dqDeptName,String zqDeptName,QinceMarketEmployeeDto mDto,Map<String,String> userMap) {
        Map<String, Object> params = new HashMap<>();
        for (QinceClienteleStoreDto storeDto : storeDtoList) {
            try {
                List<Map<String, String>> exts = new ArrayList<>();
                exts.add(Maps.of("store_ext_key", "城市经理", "store_ext_value",  Objects.isNull(mDto.getCsEmpNo()) ? "" : userMap.get(mDto.getCsEmpNo())));
                exts.add(Maps.of("store_ext_key", "战区经理", "store_ext_value", Objects.isNull(mDto.getZqEmpNo()) ? "" : userMap.get(mDto.getZqEmpNo())));
                exts.add(Maps.of("store_ext_key", "大区总监", "store_ext_value",  Objects.isNull(mDto.getDqEmpNo()) ? "" : userMap.get(mDto.getDqEmpNo())));
                exts.add(Maps.of("store_ext_key", "大区", "store_ext_value", dqDeptName));
                exts.add(Maps.of("store_ext_key", "战区", "store_ext_value", zqDeptName));

                params.put("store_waiqin_id", storeDto.getQcId());
//                params.put("store_name", storeDto.getStoreName());
                params.put("exts", exts);

                String url = qinCeUtils.builderUrl(QinCeUtils.MODIFY_STORE, params);
                qinCeUtils.postQC(url, params);
            } catch (Exception e) {
                log.error("勤策门店更新失败：{}\n{}", JSONObject.toJSONString(params), e.getMessage());
            }
        }
    }
}
