package com.sfa.job.domain.qince.dao;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.job.domain.qince.entity.QinceClienteleStore;
import com.sfa.job.domain.qince.mapper.QinceClienteleStoreMapper;
import com.sfa.job.pojo.qince.response.QinceClienteleStoreDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2025-05-09 10
 * @describe :
 */
@DS("promotion")
@Service
public class QinceClienteleStoreDaoImpl implements IQinceClienteleStoreDao {
    @Autowired
    private QinceClienteleStoreMapper qinceClienteleStoreMapper;
    @Override
    public List<QinceClienteleStoreDto> findListByDealerId(String dealerId) {
        List<QinceClienteleStore> storelist = qinceClienteleStoreMapper.findListByDealerId(dealerId);
        return BeanUtils.transitionDtos(storelist, QinceClienteleStoreDto.class);
    }

    @Override
    public List<QinceClienteleStoreDto> findListByCreateDate(String yesterday) {
        return qinceClienteleStoreMapper.findListByCreateDate(yesterday);
    }
}
