package com.sfa.job.domain.feishu.dao;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.job.domain.feishu.entity.QinceMarketEmployee;
import com.sfa.job.domain.feishu.mapper.QinceMarketEmployeeMapper;
import com.sfa.job.pojo.feishu.response.QinceMarketEmployeeDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;

/**
 * @author : liqiulin
 * @date : 2025-05-20 16
 * @describe :
 */
@DS("promotion")
@Service
public class QinceMarketEmployeeDaoImpl implements IQinceMarketEmployeeDao{

    @Autowired
    QinceMarketEmployeeMapper qinceMarketEmployeeMapper;

    @Override
    public void insert(List<QinceMarketEmployee> dos) {
        qinceMarketEmployeeMapper.batchInsert(dos);
    }

    @Override
    public List<QinceMarketEmployeeDto> selectByTodayUpdate() {
        List<QinceMarketEmployee> dos = qinceMarketEmployeeMapper.selectByTodayUpdate();
        return BeanUtils.transitionDtos(dos, QinceMarketEmployeeDto.class);
    }

    @Override
    public List<QinceMarketEmployeeDto> selectByDealerCodes(Set<String> dealerCodes) {
        List<QinceMarketEmployee> dos = qinceMarketEmployeeMapper.selectByDealerCodes(dealerCodes);
        return null;
    }
}
