package com.sfa.job.domain.order.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.sfa.job.domain.order.dao.FinanceBaseZbjTypeDao;
import com.sfa.job.domain.order.entity.FinanceBaseZbjType;
import com.sfa.job.domain.order.mapper.FinanceBaseZbjTypeMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@DS("Bi")
@Repository
public class FinianceBaseZbjTypeDaoImpl implements FinanceBaseZbjTypeDao {

    @Autowired
    FinanceBaseZbjTypeMapper mapper;

    @Override
    public Map<String, String> selectBaseZbjType() {
        List<FinanceBaseZbjType> list = mapper.selectList(new LambdaQueryWrapper<>());
        // 以fenxiaoName为key，直播间渠道类型为value，放入map中
        Map<String, String> map = list.stream()
                .collect(HashMap::new, (k, v) -> k.put(v.getFenxiaoName(), v.getZbjQdType()), HashMap::putAll);
        return map;
    }
}
