package com.sfa.job.config;

import cn.hutool.core.date.LocalDateTimeUtil;
import com.sfa.job.domain.order.dao.WdtQimenOrderPayTimeDao;
import com.sfa.job.domain.order.entity.WdtQimenOrderPayTime;
import lombok.extern.slf4j.Slf4j;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.test.context.junit4.SpringRunner;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;

/**
 * ShardingSphere分表功能测试类
 * 用于验证YearBasedShardingAlgorithm分片算法是否正确工作
 */
@ExtendWith(SpringExtension.class)
@SpringBootTest
// 关键注解：指定profile为test
@ActiveProfiles("test")
@Slf4j
public class ShardingTableTest {

    @Autowired
    private WdtQimenOrderPayTimeDao wdtQimenOrderPayTimeDao;

    /**
     * 测试插入不同年份的数据是否能正确路由到对应的分表
     */
    @Test
    public void testShardingInsert() {
        log.info("开始测试分表插入功能...");

        // 创建并插入2023年的订单
        insertOrderWithSpecificYear(2023);

        // 创建并插入2024年的订单
        insertOrderWithSpecificYear(2024);

        // 创建并插入2025年的订单
        insertOrderWithSpecificYear(2025);

        System.out.println("分表插入测试完成，请检查各年份表数据！");
    }

    /**
     * 创建并插入指定年份的订单数据
     * @param year 年份
     */
    private void insertOrderWithSpecificYear(int year) {
        WdtQimenOrderPayTime order = new WdtQimenOrderPayTime();

        // 设置基本字段
        order.setTradeId(System.currentTimeMillis());
        order.setTradeNo("TEST_" + year + "_" + new Random().nextInt(10000));
        order.setShopId(1);
        order.setShopNo("SHOP001");
        order.setPlatformId(11);
        order.setShopName("测试店铺");
        order.setTradeStatus(10); // 未付款状态
        order.setTradeType(1); // 网店销售
//        order.setPayTime(LocalDateTimeUtil.now());

        order.setCreated(String.valueOf(System.currentTimeMillis()));
        order.setCreatedDate(new Date());
        order.setDelFlag(0);
        order.setCreateTime(new Date());
        order.setUpdateTime(new Date());
        order.setDeliveryTerm(1);
        order.setRefundStatus(1);
        order.setFenxiaoType(11);
        order.setBadReason(1);
        order.setGoodsTypeCount(new BigDecimal(1));
        order.setGoodsCount(new BigDecimal(1));
        order.setGoodsAmount(new BigDecimal(1));
        order.setPostAmount(new BigDecimal(1));
        order.setOtherAmount(new BigDecimal(1));
        order.setDiscount(new BigDecimal(1));
        order.setDiscount(new BigDecimal(1));
        order.setReceivable(new BigDecimal(1));
        order.setCodAmount(new BigDecimal(1));
        order.setExtCodFee(new BigDecimal(1));
        order.setGoodsCost(new BigDecimal(1));
        order.setPostCost(new BigDecimal(1));
        order.setWeight(new BigDecimal(1));
        order.setProfit(new BigDecimal(1));
        order.setTax(new BigDecimal(1));
        order.setTaxRate(new BigDecimal(1));
        order.setCommission(new BigDecimal(1));
        order.setInvoiceType(1);
        order.setTradeFrom(1);
        order.setRawGoodsCount(new BigDecimal(1));
        order.setRawGoodsTypeCount(1);
        order.setCurrency("CNY");

        order.setCreated("1");
        order.setCreatedDate(new Date());
        order.setTradeMask(1);
        order.setPackageCost(new BigDecimal(1));
        order.setPaid(new BigDecimal(1));
        order.setLargeType(1);
        order.setGiftMask(1);
        order.setOtherCost(new BigDecimal(1));
        order.setIsSealed(true);
        order.setCustomerType(1);
        order.setDelFlag(1);
        order.setUpdateTime(new Date());
        order.setBatchNo("TEST_" + year);


        // 设置不同年份的支付时间，这是分片的关键字段
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, 0, 1, 0, 0, 0);
        order.setPayTime(LocalDateTimeUtil.of(calendar.getTime()));

        log.info("插入" + year + "年订单，payTime: " + order.getPayTime());

        // 由于是测试环境，这里可能需要特殊处理批量保存
        // 注意：实际环境中应该使用业务层方法进行保存
        wdtQimenOrderPayTimeDao.saveOrUpdateBatch(java.util.Collections.singletonList(order));
    }
}
