package com.sfa.job.xxljob.qince;

import com.sfa.job.service.qince.IQinceDealerQueryService;
import com.sfa.job.service.qince.IQinceEmpAndDeptService;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author : liqiulin
 * @date : 2025-04-24 17
 * @describe :
 */
@Component
@Slf4j
public class QinceCoreTask {
    @Autowired
    private IQinceDealerQueryService qinceDealerQueryService;
    @Autowired
    private IQinceEmpAndDeptService qinceEmpAndDeptService;

    /**
     * 回写勤策-经销商大区、战区信息
     * 每家经销商下所负责终端同时修改
     */
    @XxlJob("qince_modify_dealer")
    public void qinceCoreTask() {
        log.info("回写勤策-经销商大区、战区信息 start");
        qinceDealerQueryService.updateQinceDealerInfo();
        log.info("回写勤策-经销商大区、战区信息 end");
    }

    /**
     * 回写勤策-终端信息（仅回写昨日创建的终端）
     */
    @XxlJob("qince_modify_store")
    public void qinceCoreStore(){
        log.info("回写勤策-终端详情 start");
        qinceDealerQueryService.updateQinceStore();
        log.info("回写勤策-终端详情 end");
    }

    /**
     * 同步完飞书组织架构（sync_feishu_user）
     * 同步勤策t-1人员信息（qince_employee_task）
     * 根据飞书上下级关系，同步勤策上下级信息
     */
    @XxlJob("qince_modify_emp_leader")
    public void updateQinceEmpLeader() {
        log.info("同步勤策员工上下级关系 start");
        // 同步内部员工
        qinceEmpAndDeptService.syncQinceEmpLeaderInfo();
        // 同步经销商业代
        qinceEmpAndDeptService.syncQinceDealerUserLeaderInfo();
        log.info("同步勤策员工上下级关系 end");
    }

    /**
     * 暂停开发
     */
//    @XxlJob("qince_cus_visit_record")
    public void queryCusVisitRecord() {
        log.info("查询勤策客户拜访记录 start");
        qinceDealerQueryService.queryCusVisitRecord();
        log.info("查询勤策客户拜访记录 start");
    }
}
