package com.sfa.job.spi;

import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.shaded.com.google.common.base.Preconditions;
import com.sfa.common.core.utils.StringUtils;
import com.sfa.job.util.NacosConfigiServiceUtils;
import lombok.SneakyThrows;
import org.apache.shardingsphere.driver.jdbc.core.driver.ShardingSphereURLProvider;

import java.nio.charset.StandardCharsets;

public final class ShardingJdbcNacosURLProvider implements ShardingSphereURLProvider {

    private static final String CLASSPATH_TYPE = "nacos:";

    private static final String URL_PREFIX = "jdbc:shardingsphere:";

    @Override
    public boolean accept(String url) {
        return StringUtils.isNotEmpty(url) && url.contains(CLASSPATH_TYPE);
    }

    @SneakyThrows
    @Override
    public byte[] getContent(String url, String urlPrefix) {
        String dataId = url.substring(CLASSPATH_TYPE.length() + URL_PREFIX.length());
        Preconditions.checkArgument(!dataId.isEmpty(), "Nacos namespace is required in ShardingSphere dataId.");

        NacosConfigProperties nacosConfigProperties = NacosConfigiServiceUtils.getNacosConfigProperties();
        ConfigService configService = nacosConfigProperties.configServiceInstance();
        String content = configService.getConfig(dataId, nacosConfigProperties.getGroup(), nacosConfigProperties.getTimeout());
        return content.getBytes(StandardCharsets.UTF_8);
    }
}
