package com.sfa.job.pojo.feishu.event;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 * @author : liqiulin
 * @date : 2025-06-04 18
 * @describe :
 */
@Data
public class EventCallBackDto {

    // 事件的唯一标识。
    @JSONField(name = "uuid")
    private String uuid;
    // 事件 Token，即应用的 Verification Token。
    @JSONField(name = "token")
    private String token;
    // 事件发送时间。包含小数的秒级时间戳。
    @JSONField(name = "ts")
    private String ts;
    // 固定取值 event_callback。
    @JSONField(name = "type")
    private String type;

    @JSONField(name = "event")
    private Event event;

    @Data
    public class Event {
        // 应用的 App ID。可调用获取应用信息接口查询应用详细信息。
        @JSONField(name = "app_id")
        private String appId;
        // 审批定义 Code
        @JSONField(name = "approval_code")
        private String approvalCode;
        // 审批实例 Code
        @JSONField(name = "instance_code")
        private String fsInstanceId;
        // 事件发生事件，毫秒级时间戳。
        @JSONField(name = "instance_operate_time")
        private String instanceOperateTime;
        // 事件发生时间，毫秒级时间戳。
        @JSONField(name = "operate_time")
        private String operateTime;
        /**
         * 审批实例状态。可能值有：
         * PENDING：审批中
         * APPROVED：已通过
         * REJECTED：已拒绝
         * CANCELED：已撤回
         * DELETED：已删除
         * REVERTED：已撤销
         * OVERTIME_CLOSE：超时被关闭
         * OVERTIME_RECOVER：超时实例被恢复
         */
        @JSONField(name = "status")
        private String status;
        // 企业唯一标识。
        @JSONField(name = "tenant_key")
        private String tenantKey;
        // 事件类型。固定取值
        @JSONField(name = "type")
        private String type;
        // 如果创建审批实例时传入了 uuid，则此处返回该实例的 uuid。
        @JSONField(name = "uuid")
        private String uuid;
    }

}
