package com.sfa.job.domain.order.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * 财务-订单数据实体类，对应数据库中的 finance_order 表
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "wdt_qimen_order_pay_time")
public class WdtQimenOrderPayTime {
    /**
     * 订单唯一键
     */
    @TableId(type = IdType.NONE)
    private Long tradeId;
    /**
     * 订单编号（旺店通系统订单号）
     */
    private String tradeNo;
    /**
     * 平台 ID（请点击平台代码表查看对应关系）
     */
    private Integer platformId;
    /**
     * 仓库类型: 1、普通仓库,大于 1 为委外仓库(如京东仓储,物流宝等)，如订单无仓库的话，则不返回该字段
     */
    private Integer warehouseType;
    /**
     * 原始单号（平台订单号），如果有多个，以","分隔，且以增序排列,不重复,过长将被裁剪
     */
    private String srcTids;
    /**
     * 平台支付帐号, （仅自有平台及线下平台返回，其他平台均不返回）
     */
    private String payAccount;
    /**
     * 订单状态: 4 线下退款; 5 已取消; 6 待转预订单(待审核); 7 待转已完成; 10 未付款; 12 待尾款; 15 等未付; 16 延时审核; 19 预订单前处理; 20 审核前处理; 21 自流转待发货; 23 异常订单; 24 换货预订单; 25 待处理预订单; 27 待分配预订单; 30 待客审; 35 待财审; 40 审核中; 55 已审核; 95 已发货; 96 成本确认（待录入计划成本，订单结算时有货品无计划成本）; 101 已过账; 110 已完成
     */
    private Integer tradeStatus;
    /**
     * 订单类型: 1、网店销售; 2、线下订单; 3、售后换货; 4、批发业务; 7、现款销售; 8、分销订单; 101、自定义类型一; 102、自定义类型二; 103、自定义类型三; 104、自定义类型四; 105、自定义类型五; 106、自定义类型六; 107、自定义类型七; 108、自定义类型八; 109、自定义类型九; 110、自定义类型十（与 ERP 中自定义类型的映射关系，点击链接查看）
     */
    private Integer tradeType;
    /**
     * 发货条件: 1、款到发货; 2、货到付款(包含部分货到付款);  3、分期付款;  4、挂账
     */
    private Integer deliveryTerm;
    /**
     * 京东几环（淘宝模糊化后的买家昵称）
     */
    private String receiverRing;
    /**
     * 冻结原因
     */
    private String freezeReason;
    /**
     * 退款状态: 0、无退款; 1、申请退款; 2、部分退款; 3、全部退款
     */
    private Integer refundStatus;
    /**
     * 分销类别: 0、非分销订单; 1、代销; 2、经销
     */
    private Integer fenxiaoType;
    /**
     * 分销商昵称
     */
    private String fenxiaoNick;
    /**
     * 下单时间（毫秒级时间戳，例如：1631861379000）
     */
    private String tradeTime;
    /**
     * 付款时间，例如：2020 - 10 - 19 00:00:00
     */
    private LocalDateTime payTime;
    /**
     * 发货时间，订单未发货不返回该字段（毫秒级时间戳，例如：1631861379000）
     */
    private Date consignTime;
    /**
     * 客户网名（淘宝 ouid,淘系平台不返回）, （仅自有平台及线下平台返回，其他平台均不返回）
     */
    private String buyerNick;
    /**
     * 收货人/收件人, （仅自有平台及线下平台返回，其他平台均不返回）
     */
    private String receiverName;
    /**
     * 省份 id，可参考城市代码表
     */
    private Integer receiverProvince;
    /**
     * 城市 id，可参考城市代码表
     */
    private Integer receiverCity;
    /**
     * 地区 id，可参考城市代码表
     */
    private Integer receiverDistrict;
    /**
     * 收件人地址, （仅自有平台及线下平台返回，其他平台均不返回）
     */
    private String receiverAddress;
    /**
     * 手机,（仅自有平台及线下平台返回，其他平台均不返回）
     */
    private String receiverMobile;
    /**
     * 固话, （仅自有平台及线下平台返回，其他平台均不返回）
     */
    private String receiverTelno;
    /**
     * 邮编
     */
    private String receiverZip;
    /**
     * 地区
     */
    private String receiverArea;
    /**
     * 大头笔
     */
    private String receiverDtb;
    /**
     * 异常订单原因（位运算）: 2、修改地址; 4、修改发票; 8、更换仓库; 16、修改备注; 32、更换货品; 128、拦截赠品; 256、拦截换货; 512、买家留言变化; 1024、拦截平台已发货
     */
    private Integer badReason;
    /**
     * 物流单号
     */
    private String logisticsNo;
    /**
     * 买家留言
     */
    private String buyerMessage;
    /**
     * 客服备注
     */
    private String csRemark;
    /**
     * 标旗（1 红、2 黄、3 绿、4 蓝、5 紫 ）
     */
    private Integer remarkFlag;
    /**
     * 打印备注
     */
    private String printRemark;
    /**
     * 货品种类数
     */
    private BigDecimal goodsTypeCount;
    /**
     * 货品总量
     */
    private BigDecimal goodsCount;
    /**
     * 总货款（折前总额）
     */
    private BigDecimal goodsAmount;
    /**
     * 邮费（买家支付邮费）
     */
    private BigDecimal postAmount;
    /**
     * 其他费用
     */
    private BigDecimal otherAmount;
    /**
     * 优惠
     */
    private BigDecimal discount;
    /**
     * 应收
     */
    private BigDecimal receivable;
    /**
     * COD 金额（货到付款金额）
     */
    private BigDecimal codAmount;
    /**
     * 买家 COD 费用
     */
    private BigDecimal extCodFee;
    /**
     * 货品预估成本
     */
    private BigDecimal goodsCost;
    /**
     * 预估邮资成本
     */
    private BigDecimal postCost;
    /**
     * 预估重量（kg）
     */
    private BigDecimal weight;
    /**
     * 预估毛利
     */
    private BigDecimal profit;
    /**
     * 税额
     */
    private BigDecimal tax;
    /**
     * 税率
     */
    private BigDecimal taxRate;
    /**
     * 佣金
     */
    private BigDecimal commission;
    /**
     * 发票类型: 0：不需要; 1：普通发票; 2：增值税普通发票; 3：增值税专用发票
     */
    private Integer invoiceType;
    /**
     * 发票抬头
     */
    private String invoiceTitle;
    /**
     * 发票内容
     */
    private String invoiceContent;
    /**
     * 业务员
     */
    private String salesmanName;
    /**
     * 审核人
     */
    private String checkerName;
    /**
     * 财审人
     */
    private String fcheckerName;
    /**
     * 签出人
     */
    private String checkouterName;
    /**
     * 出库单号（系统产生的出库单号）
     */
    private String stockoutNo;
    /**
     * 标记名称
     */
    private String flagName;
    /**
     * 订单来源: 1、API 抓单; 2、手工建单; 3、导入; 4、复制订单; 5、接口推送; 6、补发订单; 7、PDA 选货开单; 8、分销补发订单
     */
    private Integer tradeFrom;
    /**
     * 货品商家编码,多种货品为空,组合装时为组合装编码
     */
    private String singleSpecNo;
    /**
     * 原始货品数量
     */
    private BigDecimal rawGoodsCount;
    /**
     * 原始货品种类数
     */
    private Integer rawGoodsTypeCount;
    /**
     * 币种
     */
    private String currency;
    /**
     * 发票 ID(自增生成)，0 代表没有发票或已取消/已冲红
     */
    private Integer invoiceId;
    /**
     * 版本号
     */
    private Integer versionId;
    /**
     * 修改时间，例如：2020 - 10 - 19 00:00:00
     */
    private Date modified;
    /**
     * 递交时间（毫秒级时间戳，例如：1631861379000）
     */
    private String created;

    /**
     * 递交时间 例如：2020 - 10 - 19 00:00:00
     */
    private Date createdDate;
    /**
     * 审核时间
     */
    private String checkTime;
    /**
     * 证件类别
     */
    private Integer idCardType;
    /**
     * 店铺编号
     */
    private String shopNo;
    /**
     * 店铺名称
     */
    private String shopName;
    /**
     * 店铺备注
     */
    private String shopRemark;
    /**
     * 仓库编号，如订单无仓库的话，则不返回该字段
     */
    private String warehouseNo;
    /**
     * 客户姓名
     */
    private String customerName;
    /**
     * 客户编码
     */
    private String customerNo;
    /**
     * 物流公司名称
     */
    private String logisticsName;
    /**
     * 物流公司编号
     */
    private String logisticsCode;
    /**
     * 物流类型名称
     */
    private String logisticsTypeName;
    /**
     * 送货时间,例如：2020 - 10 - 19 00:00:00
     */
    private String toDeliverTime;
    /**
     * 计划发货时间
     */
    private String delayToTime;
    /**
     * 最晚发货时间
     */
    private String estimateConsignTime;
    /**
     * 店铺 id
     */
    private Integer shopId;
    /**
     * 仓库 id
     */
    private Integer warehouseId;
    /**
     * 体积
     */
    private BigDecimal volume;
    /**
     * 订单标签
     */
    private String tradeLabel;
    /**
     * 1：使用智选物流; 2：货品标签; 4：预订单自动激活失败; 16：订单货品指定批次; 32：平台自动流转仓库; 64：部分发货; 128：全部发货; 256：优先占用; 512：待分配转审核失败或订单审核失败; 1024：催未付款订单短信发送标记; 2048：拆分（在判断的时候使用&运算）
     */
    private Integer tradeMask;
    /**
     * 店铺平台 id
     */
    private Integer shopPlatformId;
    /**
     * 子平台 id
     */
    private Integer subPlatformId;
    /**
     * 包装
     */
    private String packageName;
    /**
     * 包装 id
     */
    private Integer packageId;
    /**
     * 包装成本
     */
    private BigDecimal packageCost;
    /**
     * 已付
     */
    private BigDecimal paid;
    /**
     * 大件类型: 1：普通套件; 2：独立套件; 3：分组单发,未使用; -1：非单发件  取子单中的最大值
     */
    private Integer largeType;
    /**
     * 赠品标记: 1：自动赠送; 2：手工赠送; 4：回购赠送; 8：平台赠送（注意：如果是 3，则表示既有自动赠送也有手工赠送“1 + 2”）
     */
    private Integer giftMask;
    /**
     * 客户 id
     */
    private Integer customerId;
    /**
     * 其他成本
     */
    private BigDecimal otherCost;
    /**
     * 不可合并拆分
     */
    private Boolean isSealed;
    /**
     * 客户类型（0：普通客户；1：分销商；2：线下批发）
     */
    private Integer customerType;
    /**
     * 物流公司 id
     */
    private Integer logisticsId;
    /**
     * 取消原因
     */
    private String cancelReason;
    /**
     * 驳回原因
     */
    private String revertReason;
    /**
     * 订单标签 mask
     */
    private String newTradeLabel;
    /**
     * 分销原始单号（无长度限制）
     */
    private String fenxiaoTid;
    /**
     * 是否删除标志 0 未删除 1 已删除
     */
    private Integer delFlag;
    /**
     * 创建者
     */
    private String createBy;
    /**
     * 创建人 UserID
     */
    private Long createUserId;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新者
     */
    private String updateBy;
    /**
     * 修改人 UserID
     */
    private Long updateUserId;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 采集批次
     */
    private String batchNo;
    /**
     * 本批次采集开始时间，例如：2020 - 10 - 19 00:00:00
     */
    private Date startTime;
    /**
     * 本批批次采集结束时间，例如：2020 - 10 - 19 00:00:00
     */
    private Date endTime;
    /**
     * 同步类型 ，接口为 1 手动同步，0 xxljob 自动同步
     */
    private Integer syncType;
    // 订单明细
    @TableField(exist = false)
    private List<WdtQimenOrderDetailPayTime> detailList;


}
