package com.sfa.job.xxljob.erp;

import com.sfa.common.core.utils.DateUtils;
import com.sfa.job.enums.FSRecordEnum;
import com.sfa.job.service.erp.ErpAxmr005Service;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * @author : liqiulin
 * @date : 2025-04-08 13
 * @describe :
 */
@Component
@Slf4j
public class shippingTask {

    @Autowired
    private ErpAxmr005Service erpAxmr005Service;

    /**
     * 同步axmr005中t-1的数据到飞书表格
     * todo 只同步线下战区数据、部分字段
     */
    @XxlJob("axmr005_zhanqu_days")
    public void axmr005ZQByDays() {
        Date date = DateUtils.addDays(new Date(), -5);
        Integer type = FSRecordEnum.AXMR005_1.getType();
        axmr005ZQToFSByDate(date,type);
    }

    @XxlJob("axmr005_zhanqu_month")
    public void axmr005ZQByMonth() {
        Date date = DateUtils.addDays(new Date(), -4);
        Integer type = FSRecordEnum.AXMR005_2.getType();
        axmr005ZQToFSByDate(date,type);
    }

    private void axmr005ZQToFSByDate(Date date,Integer type) {
        erpAxmr005Service.axmr005ZQToFS(date, type);
    }

}
