package com.sfa.job.domain.order.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 退换货订单明细数据
 * @author lvbencai
 * @date 2025-02-28 12:26:23
 */
@Data
@TableName(value = "wdt_refund_order_detail")
public class WdtRefundOrderDetail {
    /**
     * 退换单明细Id
     */
    private Integer recId;

    /**
     * 退换单id
     */
    private Integer refundId;

    /**
     * 原始子单号
     */
    private String oid;

    /**
     * 订单明细id
     */
    private Integer tradeOrderId;

    /**
     * 平台id
     */
    private Integer platformId;

    /**
     * 原始单号
     */
    private String tid;

    /**
     * 系统订单编号
     */
    private String tradeNo;

    /**
     * 数量
     */
    private BigDecimal num;

    /**
     * 价格
     */
    private BigDecimal price;

    /**
     * 原价
     */
    private BigDecimal originalPrice;

    /**
     * 成本价
     */
    private BigDecimal checkedCostPrice;

    /**
     * 退款数量
     */
    private BigDecimal refundNum;

    /**
     * 退款总额
     */
    private BigDecimal totalAmount;

    /**
     * 已退款金额
     */
    private BigDecimal refundAmount;

    /**
     * 是否担保退款
     */
    private Boolean isGuarantee;

    /**
     * 货品编号
     */
    private String goodsNo;

    /**
     * 货品名称
     */
    private String goodsName;

    /**
     * 规格名
     */
    private String specName;

    /**
     * 商家编码
     */
    private String specNo;

    /**
     * 平台货品id
     */
    private String goodsId;

    /**
     * 平台规格id
     */
    private String specId;

    /**
     * 系统货品id
     */
    private Integer sysGoodsId;

    /**
     * 系统规格id
     */
    private Integer sysSpecId;

    /**
     * 规格码
     */
    private String specCode;

    /**
     * 条码
     */
    private String barcode;

    /**
     * 入库数量
     */
    private BigDecimal stockinNum;

    /**
     * 备注
     */
    private String remark;

    /**
     * 平台规格名称
     */
    private String apiSpecName;

    /**
     * 平台货品名称
     */
    private String apiGoodsName;

    /**
     * 最后修改时间
     */
    private String modified;

    /**
     * 组合装编号
     */
    private String suiteNo;

    /**
     * 组合装名称
     */
    private String suiteName;

    /**
     * 原始退款单号
     */
    private String rawRefundNos;

    /**
     * 原始退款单号
     */
    private String rawRefundNo;

    /**
     * 订单id
     */
    private Integer salesTradeId;

    /**
     * 总折扣金额
     */
    private BigDecimal discount;

    /**
     * 已支付金额
     */
    private BigDecimal paid;

    /**
     * 组合装id
     */
    private Integer suiteId;

    /**
     * 组合装数量
     */
    private BigDecimal suiteNum;

    /**
     * 创建时间
     */
    private String created;

    /**
     * 最后修改时间
     */
    private String modifiedDate;

    /**
     * 赠品类型
     */
    private Integer giftType;
}
