package com.sfa.job.enums;

import lombok.Getter;

/**
 * @author : liqiulin
 * @date : 2025-08-13 10
 * @describe :
 */
public interface SentReceiptEnum {

    /**
     * 回单状态类型
     * 10：回单原件（含回单照片），20：无需回单，30：回单照片，40：电子回单（传代码）
     */
    @Getter
    enum KyeReceiptEnum {
        /**
         * 回单原件（含回单照片）
         */
        RECEIPT_ORIGINAL("10","回单原件"),
        /**
         * 无需回单
         */
        NO_RECEIPT("20","无需回单"),
        /**
         * 回单照片
         */
        RECEIPT_PHOTO("30","回单照片"),
        /**
         * 电子回单（传代码）
         */
        ELECTRONIC_RECEIPT("40","电子回单");

        private String type;
        private String desc;

        KyeReceiptEnum(String type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        public static String getDesc(String type){
            if (type == null){
                return "回单异常";
            }
            for (KyeReceiptEnum value : values()) {
                if (value.getType().equals(type)){
                    return value.getDesc();
                }
            }
            return "回单异常";
        }

        public static boolean hasPhoto(String type){
            return "10".equals(type) || "30".equals(type);
        }
    }

    /**
     * 回单通用类型
     */
    @Getter
    enum ReceiptEnum {
        /**
         * 已签收未回单
         */
        NO("未回单");

        private String desc;

        ReceiptEnum(String desc) {
            this.desc = desc;
        }
    }
}
