package com.sfa.job.domain.order.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 退换货订单数据
 * @author lvbencai
 * @date 2025-02-28 12:26:29
 */
@Data
@TableName(value = "wdt_refund_amount_detail")
public class WdtRefundAmountDetail {
    /**
     * 金额明细记录id
     */
    private Integer recId;

    /**
     * 退换单id
     */
    private Integer refundId;

    /**
     * 退换类型 1:货款 2:邮费 99:返现
     */
    private Integer refundType;

    /**
     * 金额流向 0:商家->买家 1:买家->商家
     */
    private Integer isReturn;

    /**
     * 退款金额
     */
    private BigDecimal refundAmount;

    /**
     * 收款金额
     */
    private BigDecimal receiveAmount;

    /**
     * 是否担保支付
     */
    private Boolean isGuarantee;

    /**
     * 支付账户
     */
    private Integer accountId;

    /**
     * 买家账号（仅自有平台及线下平台返回）
     */
    private String payAccount;

    /**
     * 买家开户人姓名
     */
    private String accountName;

    /**
     * 开户银行
     */
    private String accountBank;

    /**
     * 是否系统自动生成
     */
    private Boolean isAuto;

    /**
     * 备注
     */
    private String remark;
}
