package com.sfa.job.domain.order.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * finance_base_zbj_type 表对应的直播间分类细腻系表。
 * 主要字段直播间渠道类型、分销商名称
 * @author lvbcai
 * @date 2025年01月07日10:04:25
 */
@Data
public class FinanceBaseZbjType {
    // 唯一键
    @TableId(type = IdType.AUTO)
    private Long fbztId;
    // 分销商名称
    private String fenxiaoName;
    // 直播间渠道类型 有分销商id,不是以上几类的，统一为达人 没有分销商id的，默认为商城
    private String zbjQdType;
    // 采集批次
    private String batchNo;
    // 备注
    private String remark;
    // 是否删除标志 0 未删除 1 已删除
    private char delFlag;
    // 创建者
    private String createBy;
    // 创建人 UserID
    private Long createUserId;
    // 创建时间
    private LocalDateTime createTime;
    // 更新者
    private String updateBy;
    // 修改人 UserID
    private Long updateUserId;
    // 更新时间
    private LocalDateTime updateTime;
}
