package com.sfa.job.domain.use.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import lombok.Data;

/**
 * 推广图片推送至飞书电子表格-分月表
 * @TableName feishu_sheet_record
 */
@TableName(value ="feishu_sheet_record")
@Data
public class FeishuSheetRecord implements Serializable {
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Integer id;

    /**
     * 电子表格token
     */
    private String sheetToken;

    /**
     * 工作表id
     */
    private String sheetId;

    /**
     * 创建月份
     */
    private String createMonth;

    /**
     * sheet页中的数据范围
     */
    private String ranges;

    /**
     * 1：axmr005_战区（每天）；2：axmr005_战区（每月）；
     */
    private Integer type;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}