package com.sfa.job.domain.order.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 退换货订单数据
 * @author lvbencai
 * @date 2025-02-28 12:26:29
 */
@Data
@TableName(value = "wdt_refund_order")
public class WdtRefundOrder {
    /**
     * 退换单id
     */
    private Integer refundId;

    /**
     * 原始单号(关联的销售单平台订单号)
     */
    private String srcTids;

    /**
     * 退换单号
     */
    private String refundNo;

    /**
     * 备注
     */
    private String remark;

    /**
     * 退换单类型 1:售前退款;2:退货;3:换货;4:退款不退货;6:保价退款
     */
    private Integer type;

    /**
     * 入库状态 0:无需入库;1:待入库;2:部分入库;3:全部入库;4:终止入库
     */
    private Integer stockinStatus;

    /**
     * 标记名称
     */
    private String flagName;

    /**
     * 退回货品数量
     */
    private BigDecimal returnGoodsCount;

    /**
     * 退款订单中收件人电话（仅自有平台及线下平台返回）
     */
    private String receiverTelno;

    /**
     * 退款订单中收件人姓名（仅自有平台及线下平台返回）
     */
    private String receiverName;

    /**
     * 修改时间
     */
    private String modified;

    /**
     * 便签数量
     */
    private Integer noteCount;

    /**
     * 店铺编号
     */
    private String shopNo;

    /**
     * 建单方式 0:API抓单;1:手工建单;2:Excel导入;3:分销商推送
     */
    private Integer fromType;

    /**
     * 建单时间
     */
    private String created;

    /**
     * 结算时间
     */
    private String settleTime;

    /**
     * 审核时间
     */
    private String checkTime;

    /**
     * 退货物流单号
     */
    private String returnLogisticsNo;

    /**
     * 系统订单号列表
     */
    private String tradeNoList;

    /**
     * 平台退款金额(担保退款金额)
     */
    private BigDecimal guaranteeRefundAmount;

    /**
     * 退货金额
     */
    private BigDecimal returnGoodsAmount;

    /**
     * 物流公司名称
     */
    private String returnLogisticsName;

    /**
     * 退换说明
     */
    private String reasonName;

    /**
     * 退款原因
     */
    private String refundReason;

    /**
     * 客户网名（仅自有平台及线下平台返回）
     */
    private String buyerNick;

    /**
     * 建单者
     */
    private String operatorName;

    /**
     * 实际退款金额
     */
    private BigDecimal actualRefundAmount;

    /**
     * 驳回原因
     */
    private String revertReasonName;

    /**
     * 退回仓库编号
     */
    private String returnWarehouseNo;

    /**
     * 线下退款金额(非担保退款金额)
     */
    private BigDecimal directRefundAmount;

    /**
     * 收款金额
     */
    private BigDecimal receiveAmount;

    /**
     * 客户姓名（仅自有平台及线下平台返回）
     */
    private String customerName;

    /**
     * 分销商昵称
     */
    private String fenxiaoNickName;

    /**
     * 退换单状态 10:已取消;20:待审核;30:已审核...
     */
    private Integer status;

    /**
     * 店铺id
     */
    private Integer shopId;

    /**
     * 订单id
     */
    private Integer tradeId;

    /**
     * 原始退换单号
     */
    private String rawRefundNos;

    /**
     * 支付订单号
     */
    private String payId;

    /**
     * 分销退换单号
     */
    private String providerRefundNo;

    /**
     * 店铺平台id
     */
    private Integer shopPlatformId;

    /**
     * 原始单号
     */
    private String tidList;

    /**
     * 子平台id
     */
    private Integer subPlatformId;

    /**
     * 退回仓库id
     */
    private Integer returnWarehouseId;

    /**
     * 平台id
     */
    private Integer platformId;

    /**
     * 奇门货主编号
     */
    private String wmsOwnerNo;

    /**
     * 退回仓库类型
     */
    private Integer warehouseType;

    /**
     * 拦截原因
     */
    private Integer badReason;

    /**
     * 最后修改时间
     */
    private String modifiedDate;

    /**
     * 退换信息
     */
    private String returnMaskInfo;

    /**
     * 处理状态
     */
    private Integer processStatus;

    /**
     * 退款原因id
     */
    private Integer reasonId;

    /**
     * 驳回原因id
     */
    private Integer revertReason;

    /**
     * 客户id
     */
    private Integer customerId;

    /**
     * 发货方式
     */
    private Integer consignMode;

    /**
     * 退款创建时间
     */
    private String refundTime;

    /**
     * 分销原始单号
     */
    private String fenxiaoTid;

    /**
     * 分销商编码
     */
    private String fenxiaoNickNo;

    /**
     * wms单号
     */
    private String wmsCode;

    /**
     * 平台状态
     */
    private Integer rrStatus;

    /**
     * 退款成功时间
     */
    private String currentPhaseTimeout;

    /**
     * 退换单详情
     */
    private List<WdtRefundOrderDetail> detailList;

    /**
     * 金额明细
     */
    private List<WdtRefundAmountDetail> amountDetailList;

    /**
     * 换出订单
     */
    private WdtSwapOrder swapOrder;
}
