package com.sfa.job.service.order.impl;

import com.alibaba.fastjson.JSONObject;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.ServiceException;
import com.sfa.job.domain.order.dao.IOrdersSentDao;
import com.sfa.job.pojo.response.OrdersSentDto;
import com.sfa.job.service.order.IOrdersSentQueryService;
import com.sfa.job.util.QinCeUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2025-07-10 16
 * @describe :
 */
@Slf4j
@Service
public class OrdersSentQueryServiceImpl implements IOrdersSentQueryService {

    @Autowired
    private IOrdersSentDao ordersSentDao;
    @Autowired
    private QinCeUtils qinCeUtils;

    @Override
    public void ordersSentToQince() {
        // 查询所有未push到勤策的发货单
        List<OrdersSentDto> sents = ordersSentDao.findByPushqcStatus();
        log.info("查询未推送到勤策的发货单：{}", sents.size());
        for (OrdersSentDto sent : sents) {
            // 修改勤策物流https地址
            pushQc(sent);
        }
    }

    @Override
    public OrdersSentDto getSent(String sentNo) {
        return ordersSentDao.getSent(sentNo);
    }

    private void pushQc(OrdersSentDto sent){
        try {
            log.info("start push qc sent no [{}] 物流轨迹", sent.getAhSentNo());
            String htmlPath = "";
            String transport = sent.getTransport();
            switch (transport) {
                case "134":
                case "109":
                    htmlPath = qinCeUtils.wlHtmlPath + sent.getAhSentNo();
                    break;
                case "132":
                    htmlPath = qinCeUtils.wlRrsPath + sent.getExpressNo();
                    break;
                case "104":
                    htmlPath = qinCeUtils.wlWlyPath + sent.getDdNo();
                    break;
                default:
                    throw new ServiceException(ECode.SENT_ISNULL_ERROR);
            }

            // 勤策中发货单按安徽匹配
            Map<String, Object> params = qinCeUtils.modifySentDefinedValParams(sent.getAhSentNo(), htmlPath);
            String url = qinCeUtils.builderUrl(QinCeUtils.MODIFY_SENT_DEFINED_VAL, params);
            qinCeUtils.postQC(url, params);
            // 推送成功
            ordersSentDao.updatePushqcByAhSentNo(sent.getAhSentNo());
            log.info("end push qc sent no [{}] 物流轨迹", sent.getAhSentNo());
        }catch (Exception e) {
            log.error("勤策推送物流地址失败，物流信息：{}", JSONObject.toJSONString(sent));
        }
    }
}
