package com.sfa.job.util;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.util.DateUtils;
import com.lark.oapi.okhttp.*;
import com.link.bi.domain.entity.FinanceOrder;
import com.sfa.common.core.exception.ServiceException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;

import java.util.*;

@Slf4j
@Component
public class WangdiantongUtil {

    /**
     * 卖家账号/接口账号/盐/接口名称
     */
    public List<FinanceOrder> queryWithDetail(Date startTime, Date endTime) {
        List<FinanceOrder> orderAllList = new ArrayList<>();

        try {
            int total = 0;
            int size = 0;
            int page_no = 0;
            do {
                String url = "http://wdt.wangdian.cn/openapi";
                String sid = "wxl3";
                String key = "wxl3-ota";
                String salt = "78784988049166748bfdc83273ebb990";
                String appsecret = "c65bd645bbed704bb7982037f9b948e3";
                String method = "sales.TradeQuery.queryWithDetail";
                String v = "1.0";

                HashMap<String, Object> params = new HashMap<>();
                params.put("start_time", DateUtils.format(startTime));
                params.put("end_time", DateUtils.format(endTime));
//                params.put("status", "110");
//                params.put("time_type", 2);

                List<HashMap<String, Object>> paramsList = Arrays.asList(params);

                String signParams = appsecret + "body" + JSONObject.toJSONString(paramsList) + "calc_total1" + "key" + key
                        + "method" + method + "page_no"+ page_no + "page_size200" + "salt" + salt + "sid" + sid +
                        "timestamp" + (System.currentTimeMillis() / 1000 - 1325347200) + "v" + v + appsecret;
                String sign = DigestUtils.md5DigestAsHex(signParams.toString().getBytes());
                log.debug(signParams);
                log.debug(sign);

                StringBuilder urlParams = new StringBuilder()
                        .append("sid=").append(sid)
                        .append("&key=").append(key)
                        .append("&salt=").append(salt)
                        .append("&method=").append(method)
                        .append("&v=").append(v)
                        .append("&timestamp=").append(System.currentTimeMillis() / 1000 - 1325347200)
                        .append("&sign=").append(sign)
                        .append("&page_size=").append(200)
                        .append("&page_no=").append(page_no)
                        .append("&calc_total=").append(1);

                log.info("查询订单数据url:" + url + "?" + urlParams);

                RequestBody body = RequestBody.create(MediaType.get("application/json"), JSONObject.toJSONString(paramsList));
                Request urlRequestBuild = new Request.Builder().url(url + "?" + urlParams).post(body).build();
                OkHttpClient client = new OkHttpClient();
                Response execute = client.newCall(urlRequestBuild).execute();
                JSONObject responseJson = JSONObject.parseObject(execute.body().string());
                JSONObject dataR = responseJson.getJSONObject("data");
                JSONObject messageJson = responseJson.getJSONObject("message");
                if(ObjectUtils.isNotEmpty(messageJson)){
                    log.error("访问旺店通接口错误"+messageJson.toString());
                    throw new ServiceException("访问旺店通接口错误"+messageJson.toString());
                }
                Integer totalCount = dataR.getInteger("total_count");
                JSONArray order = dataR.getJSONArray("order");
                total = totalCount;
                log.info("当前时间段{}-{},总条数totalCount:{}", DateUtils.format(startTime), DateUtils.format(endTime),totalCount);
                log.info("当前时间段{}-{},查询返回的order条数:{}",  DateUtils.format(startTime),DateUtils.format(endTime), order.size());

                List<FinanceOrder> orders = JSONArray.parseArray(order.toString(), FinanceOrder.class, JSONReader.Feature.SupportSmartMatch);
                orderAllList.addAll(orders);
                size = orderAllList.size();
                page_no ++;
            } while ( size < total);

            return orderAllList;
        } catch (Exception e) {
            // 记录异常日志
            log.error("异常信息：{}"+e.getMessage(),e);
            return orderAllList;
        }
    }
}
