package com.sfa.job.controller.finance;

import cn.hutool.core.date.DateUtil;
import com.link.bi.pojo.response.FinanceSyncOrderDetailDto;
import com.sfa.common.core.web.controller.BaseController;
import com.sfa.job.service.order.FinanceOrderSyncService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;

/**
 * 调度任务信息操作处理
 *
 * @author ruoyi
 */
@Slf4j
@RestController
@RequestMapping("/finance/order")
public class FinanceOrderDetailSyncController extends BaseController {
    @Autowired
    private FinanceOrderSyncService syncService;

    @GetMapping("/syncWandiantongOrderDeatail")
    public FinanceSyncOrderDetailDto syncWandiantongOrderDeatail(Date startTime, Date endTime) {
        log.info("接口开始同步-旺店通订单明细api接口数据");
        // 可以传参开始时间和结束时间，用于补充特定时间的数据采集
        FinanceSyncOrderDetailDto detailDto = syncService.syncWangdiantongOrder(startTime, endTime, 1);
        log.info("接口结束同步-旺店通订单明细api接口数据, 共同步订单{}条数据，订单明细{}条,订单批次号：{},订单的开始时间{}和结束时间{}",
                detailDto.getOrderCount(),detailDto.getOrderDetailCount(),detailDto.getBatchNo(),
                DateUtil.formatDateTime(detailDto.getStartTime()),DateUtil.formatDateTime(detailDto.getEndTime()) );
        return detailDto;
    }


}
