package com.sfa.job.domain.order.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.sfa.job.domain.order.dao.IProductDao;
import com.sfa.job.domain.order.entity.PrdInfo;
import com.sfa.job.domain.order.mapper.PrdInfoMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-11-22 16
 * @describe :
 */
@Service
public class ProductDaoImpl implements IProductDao {
    @Autowired
    PrdInfoMapper prdInfoMapper;

    @Override
    public List<PrdInfo> selectProdSeries() {
        List<PrdInfo> prdInfos = prdInfoMapper.selectList(
                new LambdaQueryWrapper<PrdInfo>()
                        .select(PrdInfo::getSeries, PrdInfo::getPrdCode, PrdInfo::getPrdName)
                        .groupBy(PrdInfo::getSeries, PrdInfo::getPrdCode, PrdInfo::getPrdName));
        return prdInfos;
    }

}
