package com.sfa.job;

import com.sfa.common.security.annotation.EnableCustomConfig;
import com.sfa.common.security.annotation.EnableRyFeignClients;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

/**
 * 定时任务
 *
 * @author ruoyi
 */
@EnableCustomConfig
@EnableRyFeignClients
@SpringBootApplication
@MapperScan("com.sfa.job.domain.*.mapper")
//@MapperScan({"com.sfa.job.domain.job.mapper","com.sfa.job.domain.system.mapper","com.sfa.job.domain.order.mapper","com.sfa.job.domain.erp.mapper","com.sfa.job.domain.use.mapper"})
public class SfaJobApplication
{
    public static void main(String[] args) {
        SpringApplication.run(SfaJobApplication.class, args);
    }
}
