package com.sfa.job.xxljob.order;

import com.link.bi.pojo.response.FinanceSyncOrderDetailDto;
import com.link.bi.service.FinanceOrderDetailService;
import com.link.bi.service.FinanceOrderService;
import com.xxl.job.core.context.XxlJobContext;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author : 吕本才
 * @date : 2025-01-15 13:03:51
 * @describe : 财务订单数据
 */
@Component
@Slf4j
public class FinanceOrderTask {

    @Autowired
    FinanceOrderDetailService orderDetailService;
    @Autowired
    FinanceOrderService orderService;

    /**
     * 同步部门数据
     */
    @XxlJob("syncWandiantongOrderDeatail")
    public FinanceSyncOrderDetailDto syncWandiantongOrderDeatail() {
        // 暂不考虑分片
        XxlJobContext xxlJobContext = XxlJobContext.getXxlJobContext();
        int shardingTotalCount = xxlJobContext.getShardTotal();
        int shardingItem = xxlJobContext.getShardIndex();

        // 简单模拟分片处理，这里输出每个分片的信息
        System.out.println("分片总数: " + shardingTotalCount + ", 当前分片: " + shardingItem);

        log.info("开始同步-旺店通订单明细api接口数据");
        // 定时任务不设定开始时间和结束时间
        FinanceSyncOrderDetailDto syncWdtOrderDetailDto = orderService.syncWandiantongOrder(null, null,0);

        log.info("结束同步-旺店通订单明细api接口数据, 共同步订单{}条数据，订单明细{}条", syncWdtOrderDetailDto.getOrderCount(),syncWdtOrderDetailDto.getOrderDetailCount());
        return syncWdtOrderDetailDto;
    }

}
