package com.sfa.job.controller.finance;

import com.link.bi.pojo.response.FinanceSyncOrderDetailDto;
import com.link.bi.service.FinanceOrderService;
import com.sfa.common.core.web.controller.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;

/**
 * 调度任务信息操作处理
 *
 * @author ruoyi
 */
@RestController
@RequestMapping("/finance/order")
public class FinanceOrderDetailSyncController extends BaseController {
    @Autowired
    private FinanceOrderService orderService;

    @GetMapping("/syncWandiantongOrderDeatail")
    public FinanceSyncOrderDetailDto syncWandiantongOrderDeatail(Date startTime, Date endTime) {
        // 可以传参开始时间和结束时间，用于补充特定时间的数据采集
        FinanceSyncOrderDetailDto syncWdtOrderDetailDto = orderService.syncWandiantongOrder(startTime, endTime, 1);
        return syncWdtOrderDetailDto;
    }


}
