package com.sfa.job;

import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import com.sfa.common.security.annotation.EnableCustomConfig;
import com.sfa.common.security.annotation.EnableRyFeignClients;
import org.springframework.context.annotation.ComponentScan;

/**
 * 定时任务
 *
 * @author ruoyi
 */
@EnableCustomConfig
@EnableRyFeignClients
@SpringBootApplication
@ComponentScan(value = {"com.sfa.job","com.link.bi.domain.*","com.link.bi.service.*","com.link.bi.pojo.*"})
@MapperScan({"com.sfa.job.domain.job.mapper","com.sfa.job.domain.system.mapper","com.link.bi.domain.mapper"})
public class SfaJobApplication
{
    public static void main(String[] args) {
        SpringApplication.run(SfaJobApplication.class, args);
    }
}
